/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice.printer;

import android.graphics.Bitmap;
import com.epson.eposdevice.EposException;
import com.epson.eposdevice.printer.BatteryLowListener;
import com.epson.eposdevice.printer.BatteryOkListener;
import com.epson.eposdevice.printer.BatteryStatusChangeListener;
import com.epson.eposdevice.printer.CoverOkListener;
import com.epson.eposdevice.printer.CoverOpenListener;
import com.epson.eposdevice.printer.DrawerClosedListener;
import com.epson.eposdevice.printer.DrawerOpenListener;
import com.epson.eposdevice.printer.JobReceiveListener;
import com.epson.eposdevice.printer.NativePrinter;
import com.epson.eposdevice.printer.OfflineListener;
import com.epson.eposdevice.printer.OnlineListener;
import com.epson.eposdevice.printer.PaperEndListener;
import com.epson.eposdevice.printer.PaperNearEndListener;
import com.epson.eposdevice.printer.PaperOkListener;
import com.epson.eposdevice.printer.PowerOffListener;
import com.epson.eposdevice.printer.ReceiveListener;
import com.epson.eposdevice.printer.StatusChangeListener;

public abstract class Printer
extends NativePrinter {
    private long mPrinterHandle = 0L;
    private int mHalftone = 0;
    private double mBrightness = 0.0;
    private boolean mforce = false;
    private int mTimeout = 0;
    private int mInterval = 0;
    private int mDrawerOpenLevel = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_UNSPECIFIED = -1;
    public static final int PARAM_DEFAULT = -2;
    public static final int ST_NO_RESPONSE = 1;
    public static final int ST_PRINT_SUCCESS = 2;
    public static final int ST_DRAWER_KICK = 4;
    public static final int ST_BATTERY_OFFLINE = 4;
    public static final int ST_OFF_LINE = 8;
    public static final int ST_COVER_OPEN = 32;
    public static final int ST_PAPER_FEED = 64;
    public static final int ST_WAIT_ON_LINE = 256;
    public static final int ST_PANEL_SWITCH = 512;
    public static final int ST_MECHANICAL_ERR = 1024;
    public static final int ST_AUTOCUTTER_ERR = 2048;
    public static final int ST_UNRECOVER_ERR = 8192;
    public static final int ST_AUTORECOVER_ERR = 16384;
    public static final int ST_RECEIPT_NEAR_END = 131072;
    public static final int ST_RECEIPT_END = 524288;
    public static final int ST_BUZZER = 0x1000000;
    public static final int ST_SPOOLER_IS_STOPPED = Integer.MIN_VALUE;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int LANG_EN = 0;
    public static final int LANG_JA = 1;
    public static final int LANG_ZH_CN = 2;
    public static final int LANG_ZH_TW = 3;
    public static final int LANG_KO = 4;
    public static final int LANG_TH = 5;
    public static final int FONT_A = 0;
    public static final int FONT_B = 1;
    public static final int FONT_C = 2;
    public static final int FONT_D = 3;
    public static final int FONT_E = 4;
    public static final int COLOR_NONE = 0;
    public static final int COLOR_1 = 1;
    public static final int COLOR_2 = 2;
    public static final int COLOR_3 = 3;
    public static final int COLOR_4 = 4;
    public static final int MODE_MONO = 0;
    public static final int MODE_GRAY16 = 1;
    public static final int HALFTONE_DITHER = 0;
    public static final int HALFTONE_ERROR_DIFFUSION = 1;
    public static final int HALFTONE_THRESHOLD = 2;
    public static final int BARCODE_UPC_A = 0;
    public static final int BARCODE_UPC_E = 1;
    public static final int BARCODE_EAN13 = 2;
    public static final int BARCODE_JAN13 = 3;
    public static final int BARCODE_EAN8 = 4;
    public static final int BARCODE_JAN8 = 5;
    public static final int BARCODE_CODE39 = 6;
    public static final int BARCODE_ITF = 7;
    public static final int BARCODE_CODABAR = 8;
    public static final int BARCODE_CODE93 = 9;
    public static final int BARCODE_CODE128 = 10;
    public static final int BARCODE_GS1_128 = 11;
    public static final int BARCODE_GS1_DATABAR_OMNIDIRECTIONAL = 12;
    public static final int BARCODE_GS1_DATABAR_TRUNCATED = 13;
    public static final int BARCODE_GS1_DATABAR_LIMITED = 14;
    public static final int BARCODE_GS1_DATABAR_EXPANDED = 15;
    public static final int HRI_NONE = 0;
    public static final int HRI_ABOVE = 1;
    public static final int HRI_BELOW = 2;
    public static final int HRI_BOTH = 3;
    public static final int SYMBOL_PDF417_STANDARD = 0;
    public static final int SYMBOL_PDF417_TRUNCATED = 1;
    public static final int SYMBOL_QRCODE_MODEL_1 = 2;
    public static final int SYMBOL_QRCODE_MODEL_2 = 3;
    public static final int SYMBOL_QRCODE_MICRO = 18;
    public static final int SYMBOL_MAXICODE_MODE_2 = 4;
    public static final int SYMBOL_MAXICODE_MODE_3 = 5;
    public static final int SYMBOL_MAXICODE_MODE_4 = 6;
    public static final int SYMBOL_MAXICODE_MODE_5 = 7;
    public static final int SYMBOL_MAXICODE_MODE_6 = 8;
    public static final int SYMBOL_GS1_DATABAR_STACKED = 9;
    public static final int SYMBOL_GS1_DATABAR_STACKED_OMNIDIRECTIONAL = 10;
    public static final int SYMBOL_GS1_DATABAR_EXPANDED_STACKED = 11;
    public static final int SYMBOL_AZTECCODE_FULLRANGE = 12;
    public static final int SYMBOL_AZTECCODE_COMPACT = 13;
    public static final int SYMBOL_DATAMATRIX_SQUARE = 14;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_8 = 15;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_12 = 16;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_16 = 17;
    public static final int LEVEL_0 = 0;
    public static final int LEVEL_1 = 1;
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    public static final int LEVEL_4 = 4;
    public static final int LEVEL_5 = 5;
    public static final int LEVEL_6 = 6;
    public static final int LEVEL_7 = 7;
    public static final int LEVEL_8 = 8;
    public static final int LEVEL_L = 9;
    public static final int LEVEL_M = 10;
    public static final int LEVEL_Q = 11;
    public static final int LEVEL_H = 12;
    public static final int LEVEL_DEFAULT = 13;
    public static final int LINE_THIN = 0;
    public static final int LINE_MEDIUM = 1;
    public static final int LINE_THICK = 2;
    public static final int LINE_THIN_DOUBLE = 3;
    public static final int LINE_MEDIUM_DOUBLE = 4;
    public static final int LINE_THICK_DOUBLE = 5;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_BOTTOM_TO_TOP = 1;
    public static final int DIRECTION_RIGHT_TO_LEFT = 2;
    public static final int DIRECTION_TOP_TO_BOTTOM = 3;
    public static final int CUT_NO_FEED = 0;
    public static final int CUT_FEED = 1;
    public static final int CUT_RESERVE = 2;
    public static final int DRAWER_1 = 0;
    public static final int DRAWER_2 = 1;
    public static final int PULSE_100 = 0;
    public static final int PULSE_200 = 1;
    public static final int PULSE_300 = 2;
    public static final int PULSE_400 = 3;
    public static final int PULSE_500 = 4;
    public static final int PATTERN_NONE = 0;
    public static final int PATTERN_A = 1;
    public static final int PATTERN_B = 2;
    public static final int PATTERN_C = 3;
    public static final int PATTERN_D = 4;
    public static final int PATTERN_E = 5;
    public static final int PATTERN_ERROR = 6;
    public static final int PATTERN_PAPER_END = 7;
    public static final int PATTERN_1 = 8;
    public static final int PATTERN_2 = 9;
    public static final int PATTERN_3 = 10;
    public static final int PATTERN_4 = 11;
    public static final int PATTERN_5 = 12;
    public static final int PATTERN_6 = 13;
    public static final int PATTERN_7 = 14;
    public static final int PATTERN_8 = 15;
    public static final int PATTERN_9 = 16;
    public static final int PATTERN_10 = 17;
    public static final int FEED_PEELING = 0;
    public static final int FEED_CUTTING = 1;
    public static final int FEED_CURRENT_TOF = 2;
    public static final int FEED_NEXT_TOF = 3;
    public static final int LAYOUT_RECEIPT = 0;
    public static final int LAYOUT_LABEL = 1;
    public static final int LAYOUT_LABEL_BM = 2;
    public static final int LAYOUT_RECEIPT_BM = 3;
    public static final int DRAWER_OPEN_LEVEL_LOW = 0;
    public static final int DRAWER_OPEN_LEVEL_HIGH = 1;
    private final int MIN_IMAGE_WIDTH = 1;
    private final int MIN_IMAGE_HEIGHT = 1;
    private final int MIN_PRINTJOBID_LENGTH = 1;
    private final int MAX_PRINTJOBID_LENGTH = 30;
    private final boolean BLANK_TRUE = true;
    private final boolean BLANK_FALSE = false;
    private StatusChangeListener mStatusChangeListener;
    private OnlineListener mOnlineListener;
    private OfflineListener mOfflineListener;
    private PowerOffListener mPowerOffListener;
    private CoverOkListener mCoverOkListener;
    private CoverOpenListener mCoverOpenListener;
    private PaperOkListener mPaperOkListener;
    private PaperNearEndListener mPaperNearEndListener;
    private PaperEndListener mPaperEndListener;
    private DrawerClosedListener mDrawerClosedListener;
    private DrawerOpenListener mDrawerOpenListener;
    private BatteryLowListener mBatteryLowListener;
    private BatteryOkListener mBatteryOkListener;
    private BatteryStatusChangeListener mBatteryStatusChangeListener;
    private ReceiveListener mReceiveListener;
    private JobReceiveListener mJobReceiveListener;
    private static final int DEFAULT_INTERVAL = 3000;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final double DEFAULT_BRIGHTNESS = 1.0;

    protected long getInnerHandle() {
        return this.mPrinterHandle;
    }

    protected void innerDeleteInstance() {
        this.nativeSetPtrStatusChangeEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrOnlineEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrOfflineEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrPowerOffEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrCoverOkEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrCoverOpenEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrPaperOkEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrPaperNearEndEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrPaperEndEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrDrawerClosedEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrDrawerOpenEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrBatteryLowEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrBatteryOkEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrBatteryStatusChangeEventCallback(this.mPrinterHandle, null);
        this.nativeSetPtrReceiveEventCallback(this.mPrinterHandle, null);
        this.mPrinterHandle = 0L;
    }

    protected void checkHandle() throws EposException {
        if (this.mPrinterHandle == 0L) {
            throw new EposException(255);
        }
    }

    protected void checkPrintJobIdFormat(String printJobId) throws EposException {
        if (printJobId == null) {
            throw new EposException(1);
        }
        if (printJobId.length() < 1 || 30 < printJobId.length()) {
            throw new EposException(1);
        }
        if (printJobId.matches(".*[^-._0-9A-Za-z].*")) {
            throw new EposException(1);
        }
    }

    private void onPtrStatusChange(String ipAddress, String deviceId, int status) {
        if (null != this.mStatusChangeListener) {
            this.outputLogEvent("onPtrStatusChange", ipAddress, deviceId, status);
            this.mStatusChangeListener.onPtrStatusChange(ipAddress, deviceId, status);
        }
    }

    private void onPtrOnline(String ipAddress, String deviceId) {
        if (null != this.mOnlineListener) {
            this.outputLogEvent("onPtrOnline", ipAddress, deviceId);
            this.mOnlineListener.onPtrOnline(ipAddress, deviceId);
        }
    }

    private void onPtrOffline(String ipAddress, String deviceId) {
        if (null != this.mOfflineListener) {
            this.outputLogEvent("onPtrOffline", ipAddress, deviceId);
            this.mOfflineListener.onPtrOffline(ipAddress, deviceId);
        }
    }

    private void onPtrPowerOff(String ipAddress, String deviceId) {
        if (null != this.mPowerOffListener) {
            this.outputLogEvent("onPtrPowerOff", ipAddress, deviceId);
            this.mPowerOffListener.onPtrPowerOff(ipAddress, deviceId);
        }
    }

    private void onPtrCoverOk(String ipAddress, String deviceId) {
        if (null != this.mCoverOkListener) {
            this.outputLogEvent("onPtrCoverOk", ipAddress, deviceId);
            this.mCoverOkListener.onPtrCoverOk(ipAddress, deviceId);
        }
    }

    private void onPtrCoverOpen(String ipAddress, String deviceId) {
        if (null != this.mCoverOpenListener) {
            this.outputLogEvent("onPtrCoverOpen", ipAddress, deviceId);
            this.mCoverOpenListener.onPtrCoverOpen(ipAddress, deviceId);
        }
    }

    private void onPtrPaperOk(String ipAddress, String deviceId) {
        if (null != this.mPaperOkListener) {
            this.outputLogEvent("onPtrPaperOk", ipAddress, deviceId);
            this.mPaperOkListener.onPtrPaperOk(ipAddress, deviceId);
        }
    }

    private void onPtrPaperNearEnd(String ipAddress, String deviceId) {
        if (null != this.mPaperNearEndListener) {
            this.outputLogEvent("onPtrPaperNearEnd", ipAddress, deviceId);
            this.mPaperNearEndListener.onPtrPaperNearEnd(ipAddress, deviceId);
        }
    }

    private void onPtrPaperEnd(String ipAddress, String deviceId) {
        if (null != this.mPaperEndListener) {
            this.outputLogEvent("onPtrPaperEnd", ipAddress, deviceId);
            this.mPaperEndListener.onPtrPaperEnd(ipAddress, deviceId);
        }
    }

    private void onPtrDrawerClosed(String ipAddress, String deviceId) {
        if (null != this.mDrawerClosedListener) {
            this.outputLogEvent("onPtrDrawerClosed", ipAddress, deviceId);
            this.mDrawerClosedListener.onPtrDrawerClosed(ipAddress, deviceId);
        }
    }

    private void onPtrDrawerOpen(String ipAddress, String deviceId) {
        if (null != this.mDrawerOpenListener) {
            this.outputLogEvent("onPtrDrawerOpen", ipAddress, deviceId);
            this.mDrawerOpenListener.onPtrDrawerOpen(ipAddress, deviceId);
        }
    }

    private void onPtrBatteryLow(String ipAddress, String deviceId) {
        if (null != this.mBatteryLowListener) {
            this.outputLogEvent("onPtrBatteryLow", ipAddress, deviceId);
            this.mBatteryLowListener.onPtrBatteryLow(ipAddress, deviceId);
        }
    }

    private void onPtrBatteryOk(String ipAddress, String deviceId) {
        if (null != this.mBatteryOkListener) {
            this.outputLogEvent("onPtrBatteryOk", ipAddress, deviceId);
            this.mBatteryOkListener.onPtrBatteryOk(ipAddress, deviceId);
        }
    }

    private void onPtrBatteryStatusChange(String ipAddress, String deviceId, int battery) {
        if (null != this.mBatteryStatusChangeListener) {
            this.outputLogEvent("onPtrBatteryStatusChange", ipAddress, deviceId, battery);
            this.mBatteryStatusChangeListener.onPtrBatteryStatusChange(ipAddress, deviceId, battery);
        }
    }

    private void onPtrReceive(String ipAddress, String deviceId, int success, int code, int status, int battery) {
        if (null != this.mReceiveListener) {
            this.outputLogEvent("onPtrReceive", ipAddress, deviceId, success, code, status, battery);
            this.mReceiveListener.onPtrReceive(ipAddress, deviceId, success, code, status, battery);
        }
    }

    private void onPtrReceive(String ipAddress, String deviceId, int success, int code, int status, int battery, String printJobId) {
        if (null != this.mJobReceiveListener) {
            this.outputLogEvent("onPtrReceive", ipAddress, deviceId, success, code, status, battery, printJobId);
            this.mJobReceiveListener.onPtrReceive(ipAddress, deviceId, success, code, status, battery, printJobId);
        }
    }

    protected Printer(long ptrHandle) {
        this.mPrinterHandle = ptrHandle;
        this.mHalftone = 0;
        this.mBrightness = 1.0;
        this.mforce = false;
        this.mTimeout = 10000;
        this.mInterval = 3000;
        this.mDrawerOpenLevel = 0;
    }

    public void setHalftone(int halftone) throws EposException {
        this.outputLogCallFunction("setHalftone", halftone);
        try {
            switch (halftone) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new EposException(1);
                }
            }
            this.mHalftone = halftone;
        }
        catch (EposException ex) {
            this.outputException("setHalftone", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setHalftone", halftone);
    }

    public int getHalftone() {
        return this.mHalftone;
    }

    public void setBrightness(double brightness) throws EposException {
        this.outputLogCallFunction("setBrightness", brightness);
        try {
            int valueParam = (int)(brightness * 10.0);
            if (valueParam < 1 || 100 < valueParam) {
                throw new EposException(1);
            }
            this.mBrightness = brightness;
        }
        catch (EposException ex) {
            this.outputException("setBrightness", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setBrightness", brightness);
    }

    public double getBrightness() {
        return this.mBrightness;
    }

    public void setForce(boolean force) {
        this.outputLogCallFunction("setForce", force);
        this.mforce = force;
        this.outputLogReturnFunction("setForce", force);
    }

    public boolean getForce() {
        return this.mforce;
    }

    public void setTimeout(int timeout) throws EposException {
        this.outputLogCallFunction("setTimeout", timeout);
        try {
            if (timeout < 0 || 600000 < timeout) {
                throw new EposException(1);
            }
            this.mTimeout = timeout;
        }
        catch (EposException ex) {
            this.outputException("setTimeout", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setTimeout", timeout);
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setInterval(int interval) throws EposException {
        this.outputLogCallFunction("setInterval", interval);
        try {
            if (interval < 1000 || 6000 < interval) {
                throw new EposException(1);
            }
            this.mInterval = interval;
            this.nativeSetInterval(this.mPrinterHandle, interval);
        }
        catch (EposException ex) {
            this.outputException("setInterval", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setInterval", interval);
    }

    public int getInterval() {
        return this.mInterval;
    }

    public void setDrawerOpenLevel(int drawerOpenLevel) throws EposException {
        this.outputLogCallFunction("setDrawerOpenLevel", drawerOpenLevel);
        try {
            switch (drawerOpenLevel) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new EposException(1);
                }
            }
            int errStatus = this.nativeSetDrawerOpenLevel(this.mPrinterHandle, drawerOpenLevel);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
            this.mDrawerOpenLevel = drawerOpenLevel;
        }
        catch (EposException ex) {
            this.outputException("setDrawerOpenLevel", ex);
            throw ex;
        }
    }

    public int getDrawerOpenLevel() {
        return this.mDrawerOpenLevel;
    }

    public void startMonitor() throws EposException {
        this.outputLogCallFunction("startMonitor", new Object[0]);
        try {
            this.checkHandle();
            this.nativeStartMonitor(this.mPrinterHandle, this.mInterval);
        }
        catch (EposException ex) {
            this.outputException("startMonitor", ex);
            throw ex;
        }
        this.outputLogReturnFunction("startMonitor", new Object[0]);
    }

    public void stopMonitor() throws EposException {
        this.outputLogCallFunction("stopMonitor", new Object[0]);
        try {
            this.checkHandle();
            this.nativeStopMonitor(this.mPrinterHandle);
        }
        catch (EposException ex) {
            this.outputException("stopMonitor", ex);
            throw ex;
        }
        this.outputLogReturnFunction("stopMonitor", new Object[0]);
    }

    public void sendData() throws EposException {
        this.outputLogCallFunction("sendData", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeSendData(this.mPrinterHandle, this.mTimeout, "", this.mforce, false);
            this.mforce = false;
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("sendData", ex);
            throw ex;
        }
        this.outputLogReturnFunction("sendData", new Object[0]);
    }

    public void sendData(String printJobId) throws EposException {
        this.outputLogCallFunction("sendData use JobId", new Object[0]);
        try {
            this.checkHandle();
            this.checkPrintJobIdFormat(printJobId);
            int errStatus = this.nativeSendData(this.mPrinterHandle, this.mTimeout, printJobId, this.mforce, false);
            this.mforce = false;
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("sendData use JobId", ex);
            throw ex;
        }
        this.outputLogReturnFunction("sendData use JobId", new Object[0]);
    }

    public void getPrintJobStatus(String printJobId) throws EposException {
        this.outputLogCallFunction("getPrintJobStatus", new Object[0]);
        try {
            this.checkHandle();
            this.checkPrintJobIdFormat(printJobId);
            int errStatus = this.nativeSendData(this.mPrinterHandle, this.mTimeout, printJobId, this.mforce, true);
            this.mforce = false;
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("getPrintJobStatus", ex);
            throw ex;
        }
        this.outputLogReturnFunction("getPrintJobStatus", new Object[0]);
    }

    public void clearCommandBuffer() {
        this.outputLogCallFunction("clearCommandBuffer", new Object[0]);
        if (this.mPrinterHandle != 0L) {
            this.nativeClearCommandBuffer(this.mPrinterHandle);
        }
        this.outputLogReturnFunction("clearCommandBuffer", new Object[0]);
    }

    public void addTextAlign(int align) throws EposException {
        this.outputLogCallFunction("addTextAlign", align);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextAlign(this.mPrinterHandle, align);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextAlign", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextAlign", align);
    }

    public void addTextLineSpace(int linespc) throws EposException {
        this.outputLogCallFunction("addTextLineSpace", linespc);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextLineSpace(this.mPrinterHandle, linespc);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextLineSpace", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextLineSpace", linespc);
    }

    public void addTextRotate(int rotate) throws EposException {
        this.outputLogCallFunction("addTextRotate", rotate);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextRotate(this.mPrinterHandle, rotate);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextRotate", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextRotate", rotate);
    }

    public void addText(String data) throws EposException {
        this.outputLogCallFunction("addText", data);
        try {
            this.checkHandle();
            if (null == data) {
                throw new EposException(1);
            }
            int errStatus = this.nativeAddText(this.mPrinterHandle, data);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addText", data);
    }

    public void addTextLang(int lang) throws EposException {
        this.outputLogCallFunction("addTextLang", lang);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextLang(this.mPrinterHandle, lang);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextLang", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextLang", lang);
    }

    public void addTextFont(int font) throws EposException {
        this.outputLogCallFunction("addTextFont", font);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextFont(this.mPrinterHandle, font);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextFont", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextFont", font);
    }

    public void addTextSmooth(int smooth) throws EposException {
        this.outputLogCallFunction("addTextSmooth", smooth);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextSmooth(this.mPrinterHandle, smooth);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextSmooth", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextSmooth", smooth);
    }

    public void addTextDouble(int dw, int dh) throws EposException {
        this.outputLogCallFunction("addTextDouble", dw, dh);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextDouble(this.mPrinterHandle, dw, dh);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextDouble", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextDouble", dw, dh);
    }

    public void addTextSize(int width, int height) throws EposException {
        this.outputLogCallFunction("addTextSize", width, height);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextSize(this.mPrinterHandle, width, height);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextSize", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextSize", width, height);
    }

    public void addTextStyle(int reverse, int ul, int em, int color2) throws EposException {
        this.outputLogCallFunction("addTextStyle", reverse, ul, em, color2);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextStyle(this.mPrinterHandle, reverse, ul, em, color2);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextStyle", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextStyle", reverse, ul, em, color2);
    }

    public void addTextPosition(int x) throws EposException {
        this.outputLogCallFunction("addTextPosition", x);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextPosition(this.mPrinterHandle, x);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextPosition", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextPosition", x);
    }

    public void addTextVPosition(int y) throws EposException {
        this.outputLogCallFunction("addTextVPosition", y);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddTextVPosition(this.mPrinterHandle, y);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addTextVPosition", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addTextVPosition", y);
    }

    public void addFeedUnit(int unit) throws EposException {
        this.outputLogCallFunction("addFeedUnit", unit);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddFeedUnit(this.mPrinterHandle, unit);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addFeedUnit", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addFeedUnit", unit);
    }

    public void addFeedLine(int line) throws EposException {
        this.outputLogCallFunction("addFeedLine", line);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddFeedLine(this.mPrinterHandle, line);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addFeedLine", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addFeedLine", line);
    }

    public void addFeed() throws EposException {
        this.outputLogCallFunction("addFeed", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddFeed(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addFeed", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addFeed", new Object[0]);
    }

    public void addImage(Bitmap data, int x, int y, int width, int height, int color2, int mode) throws EposException {
        this.outputLogCallFunction("addImage", data, x, y, width, height, color2, mode);
        try {
            double[] divTable;
            int[] lineBuf;
            int row;
            int line;
            int b;
            int g;
            int r;
            int alpha;
            int srcPos;
            int srcHeight;
            int srcWidth;
            block20: {
                block19: {
                    this.checkHandle();
                    if (null == data) {
                        throw new EposException(1);
                    }
                    int bgrBytePerPixel = 3;
                    int maxByteValue = 255;
                    srcWidth = data.getWidth();
                    srcHeight = data.getHeight();
                    int byteMask = 255;
                    int shiftBitForAlpha = 24;
                    int shiftBitForRed = 16;
                    int shiftBitForGreen = 8;
                    srcPos = 0;
                    int dstPos = 0;
                    alpha = 0;
                    r = 0;
                    g = 0;
                    b = 0;
                    line = 0;
                    row = 0;
                    lineBuf = new int[srcWidth];
                    int divTableSize = 256;
                    divTable = new double[256];
                    this.getClass();
                    if (1 > srcWidth) break block19;
                    this.getClass();
                    if (1 <= srcHeight) break block20;
                }
                throw new EposException(1);
            }
            Bitmap image = null;
            if (data.getConfig() == Bitmap.Config.ARGB_8888) {
                image = data;
            } else {
                image = data.copy(Bitmap.Config.ARGB_8888, false);
                if (null == image) {
                    throw new EposException(12);
                }
            }
            for (int i = 0; i < 256; ++i) {
                divTable[i] = 1.0 - (double)i / 255.0;
            }
            byte[] imageBGR = new byte[3 * srcWidth * srcHeight];
            for (line = 0; line < srcHeight; ++line) {
                image.getPixels(lineBuf, 0, srcWidth, 0, line, srcWidth, 1);
                srcPos = 0;
                for (row = 0; row < srcWidth; ++row) {
                    alpha = lineBuf[srcPos] >> 24 & 0xFF;
                    r = lineBuf[srcPos] >> 16 & 0xFF;
                    g = lineBuf[srcPos] >> 8 & 0xFF;
                    b = lineBuf[srcPos] & 0xFF;
                    if (255 == alpha) {
                        imageBGR[dstPos] = (byte)b;
                        imageBGR[dstPos + 1] = (byte)g;
                        imageBGR[dstPos + 2] = (byte)r;
                    } else if (0 == alpha) {
                        imageBGR[dstPos] = -1;
                        imageBGR[dstPos + 1] = -1;
                        imageBGR[dstPos + 2] = -1;
                    } else {
                        imageBGR[dstPos] = (byte)(255.0 - (double)alpha * divTable[b]);
                        imageBGR[dstPos + 1] = (byte)(255.0 - (double)alpha * divTable[g]);
                        imageBGR[dstPos + 2] = (byte)(255.0 - (double)alpha * divTable[r]);
                    }
                    dstPos += 3;
                    ++srcPos;
                }
            }
            int errStatus = this.nativeAddImage(this.mPrinterHandle, imageBGR, srcWidth, srcHeight, x, y, width, height, color2, mode, this.mHalftone, this.mBrightness);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addImage", ex);
            throw ex;
        }
        catch (OutOfMemoryError ex) {
            EposException eposEx = new EposException(12);
            this.outputException("addImage", eposEx);
            throw eposEx;
        }
        this.outputLogReturnFunction("addImage", data, x, y, width, height, color2, mode);
    }

    public void addLogo(int key1, int key2) throws EposException {
        this.outputLogCallFunction("addLogo", key1, key2);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddLogo(this.mPrinterHandle, key1, key2);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addLogo", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addLogo", key1, key2);
    }

    public void addBarcode(String data, int type, int hri, int font, int width, int height) throws EposException {
        this.outputLogCallFunction("addBarcode", data, type, hri, font, width);
        try {
            this.checkHandle();
            if (null == data) {
                throw new EposException(1);
            }
            int errStatus = this.nativeAddBarcode(this.mPrinterHandle, data, type, hri, font, width, height);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addBarcode", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addBarcode", data, type, hri, font, width);
    }

    public void addSymbol(String data, int type, int level, int width, int height, int size) throws EposException {
        this.outputLogCallFunction("addSymbol", data, type, level, width, height, size);
        try {
            this.checkHandle();
            if (null == data) {
                throw new EposException(1);
            }
            int errStatus = this.nativeAddSymbol(this.mPrinterHandle, data, type, level, width, height, size);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addSymbol", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addSymbol", data, type, level, width, height, size);
    }

    public void addHLine(int x1, int x2, int style) throws EposException {
        this.outputLogCallFunction("addHLine", x1, x2, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddHLine(this.mPrinterHandle, x1, x2, style);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addHLine", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addHLine", x1, x2, style);
    }

    public void addVLineBegin(int x, int style) throws EposException {
        this.outputLogCallFunction("addVLineBegin", x, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddVLineBegin(this.mPrinterHandle, x, style);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addVLineBegin", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addVLineBegin", x, style);
    }

    public void addVLineEnd(int x, int style) throws EposException {
        this.outputLogCallFunction("addVLineEnd", x, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddVLineEnd(this.mPrinterHandle, x, style);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addVLineEnd", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addVLineEnd", x, style);
    }

    public void addPageBegin() throws EposException {
        this.outputLogCallFunction("addPageBegin", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPageBegin(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPageBegin", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPageBegin", new Object[0]);
    }

    public void addPageEnd() throws EposException {
        this.outputLogCallFunction("addPageEnd", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPageEnd(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPageEnd", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPageEnd", new Object[0]);
    }

    public void addPageArea(int x, int y, int width, int height) throws EposException {
        this.outputLogCallFunction("addPageArea", x, y, width, height);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPageArea(this.mPrinterHandle, x, y, width, height);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPageArea", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPageArea", x, y, width, height);
    }

    public void addPageDirection(int dir) throws EposException {
        this.outputLogCallFunction("addPageDirection", dir);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPageDirection(this.mPrinterHandle, dir);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPageDirection", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPageDirection", dir);
    }

    public void addPagePosition(int x, int y) throws EposException {
        this.outputLogCallFunction("addPagePosition", x, y);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPagePosition(this.mPrinterHandle, x, y);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPagePosition", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPagePosition", x, y);
    }

    public void addPageLine(int x1, int y1, int x2, int y2, int style) throws EposException {
        this.outputLogCallFunction("addPageLine", x1, y1, x2, y2, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPageLine(this.mPrinterHandle, x1, y1, x2, y2, style);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPageLine", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPageLine", x1, y1, x2, y2, style);
    }

    public void addPageRectangle(int x1, int y1, int x2, int y2, int style) throws EposException {
        this.outputLogCallFunction("addPageRectangle", x1, y1, x2, y2, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPageRectangle(this.mPrinterHandle, x1, y1, x2, y2, style);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPageRectangle", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPageRectangle", x1, y1, x2, y2, style);
    }

    public void addCut(int type) throws EposException {
        this.outputLogCallFunction("addCut", type);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddCut(this.mPrinterHandle, type);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addCut", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addCut", type);
    }

    public void addPulse(int drawer, int time) throws EposException {
        this.outputLogCallFunction("addPulse", drawer, time);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddPulse(this.mPrinterHandle, drawer, time);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addPulse", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addPulse", drawer, time);
    }

    public void addSound(int pattern, int repeat, int cycle) throws EposException {
        this.outputLogCallFunction("addSound", pattern, repeat, cycle);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddSound(this.mPrinterHandle, pattern, repeat, cycle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addSound", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addSound", pattern, repeat, cycle);
    }

    public void addFeedPosition(int position) throws EposException {
        this.outputLogCallFunction("addFeedPosition", position);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddFeedPosition(this.mPrinterHandle, position);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addFeedPosition", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addFeedPosition", position);
    }

    public void addLayout(int type, int width, int height, int marginTop, int marginBottom, int offsetCut, int offsetLabel) throws EposException {
        this.outputLogCallFunction("addLayout", type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddLayout(this.mPrinterHandle, type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addLayout", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addLayout", type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
    }

    public void addCommand(byte[] data) throws EposException {
        this.outputLogCallFunction("addCommand", new Object[]{data});
        try {
            this.checkHandle();
            if (null == data) {
                throw new EposException(1);
            }
            int errStatus = this.nativeAddCommand(this.mPrinterHandle, data);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addCommand", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addCommand", new Object[]{data});
    }

    public void addRecovery() throws EposException {
        this.outputLogCallFunction("addRecovery", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddRecovery(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addRecovery", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addRecovery", new Object[0]);
    }

    public void addReset() throws EposException {
        this.outputLogCallFunction("addReset", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeAddReset(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("addReset", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addReset", new Object[0]);
    }

    public void recover() throws EposException {
        this.outputLogCallFunction("recover", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeRecovery(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("recover", ex);
            throw ex;
        }
        this.outputLogReturnFunction("recover", new Object[0]);
    }

    public void reset() throws EposException {
        this.outputLogCallFunction("reset", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeReset(this.mPrinterHandle, this.mforce);
            this.mforce = false;
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("reset", ex);
            throw ex;
        }
        this.outputLogReturnFunction("reset", new Object[0]);
    }

    public void setStatusChangeEventCallback(StatusChangeListener statusChangeListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (statusChangeListener != null) {
            this.mStatusChangeListener = statusChangeListener;
            this.nativeSetPtrStatusChangeEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrStatusChangeEventCallback(this.mPrinterHandle, null);
            this.mStatusChangeListener = null;
        }
    }

    public void setOnlineEventCallback(OnlineListener onlineListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (onlineListener != null) {
            this.mOnlineListener = onlineListener;
            this.nativeSetPtrOnlineEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrOnlineEventCallback(this.mPrinterHandle, null);
            this.mOnlineListener = null;
        }
    }

    public void setOfflineEventCallback(OfflineListener offlineListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (offlineListener != null) {
            this.mOfflineListener = offlineListener;
            this.nativeSetPtrOfflineEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrOfflineEventCallback(this.mPrinterHandle, null);
            this.mOfflineListener = null;
        }
    }

    public void setPowerOffEventCallback(PowerOffListener powerOffListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (powerOffListener != null) {
            this.mPowerOffListener = powerOffListener;
            this.nativeSetPtrPowerOffEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrPowerOffEventCallback(this.mPrinterHandle, null);
            this.mPowerOffListener = null;
        }
    }

    public void setCoverOkEventCallback(CoverOkListener coverOkListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (coverOkListener != null) {
            this.mCoverOkListener = coverOkListener;
            this.nativeSetPtrCoverOkEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrCoverOkEventCallback(this.mPrinterHandle, null);
            this.mCoverOkListener = null;
        }
    }

    public void setPaperOkEventCallback(PaperOkListener paperOkListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (paperOkListener != null) {
            this.mPaperOkListener = paperOkListener;
            this.nativeSetPtrPaperOkEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrPaperOkEventCallback(this.mPrinterHandle, null);
            this.mPaperOkListener = null;
        }
    }

    public void setPaperNearEndEventCallback(PaperNearEndListener paperNearEndListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (paperNearEndListener != null) {
            this.mPaperNearEndListener = paperNearEndListener;
            this.nativeSetPtrPaperNearEndEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrPaperNearEndEventCallback(this.mPrinterHandle, null);
            this.mPaperNearEndListener = null;
        }
    }

    public void setPaperEndEventCallback(PaperEndListener paperEndListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (paperEndListener != null) {
            this.mPaperEndListener = paperEndListener;
            this.nativeSetPtrPaperEndEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrPaperEndEventCallback(this.mPrinterHandle, null);
            this.mPaperEndListener = null;
        }
    }

    public void setCoverOpenEventCallback(CoverOpenListener coverOpenListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (coverOpenListener != null) {
            this.mCoverOpenListener = coverOpenListener;
            this.nativeSetPtrCoverOpenEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrCoverOpenEventCallback(this.mPrinterHandle, null);
            this.mCoverOpenListener = null;
        }
    }

    public void setDrawerClosedEventCallback(DrawerClosedListener drawerClosedListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (drawerClosedListener != null) {
            this.mDrawerClosedListener = drawerClosedListener;
            this.nativeSetPtrDrawerClosedEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrDrawerClosedEventCallback(this.mPrinterHandle, null);
            this.mDrawerClosedListener = null;
        }
    }

    public void setDrawerOpenEventCallback(DrawerOpenListener drawerOpenListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (drawerOpenListener != null) {
            this.mDrawerOpenListener = drawerOpenListener;
            this.nativeSetPtrDrawerOpenEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrDrawerOpenEventCallback(this.mPrinterHandle, null);
            this.mDrawerOpenListener = null;
        }
    }

    public void setBatteryLowEventCallback(BatteryLowListener batteryLowListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (batteryLowListener != null) {
            this.mBatteryLowListener = batteryLowListener;
            this.nativeSetPtrBatteryLowEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrBatteryLowEventCallback(this.mPrinterHandle, null);
            this.mBatteryLowListener = null;
        }
    }

    public void setBatteryOkEventCallback(BatteryOkListener batteryOkListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (batteryOkListener != null) {
            this.mBatteryOkListener = batteryOkListener;
            this.nativeSetPtrBatteryOkEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrBatteryOkEventCallback(this.mPrinterHandle, null);
            this.mBatteryOkListener = null;
        }
    }

    public void setBatteryStatusChangeEventCallback(BatteryStatusChangeListener batteryStatusChangeListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (batteryStatusChangeListener != null) {
            this.mBatteryStatusChangeListener = batteryStatusChangeListener;
            this.nativeSetPtrBatteryStatusChangeEventCallback(this.mPrinterHandle, this);
        } else {
            this.nativeSetPtrBatteryStatusChangeEventCallback(this.mPrinterHandle, null);
            this.mBatteryStatusChangeListener = null;
        }
    }

    public void setReceiveEventCallback(ReceiveListener receiveListener) {
        if (this.mPrinterHandle == 0L) {
            return;
        }
        if (receiveListener != null) {
            if (receiveListener instanceof JobReceiveListener) {
                this.mJobReceiveListener = (JobReceiveListener)receiveListener;
                this.nativeSetPtrReceiveEventCallback(this.mPrinterHandle, this);
            } else {
                this.mReceiveListener = receiveListener;
                this.nativeSetPtrReceiveEventCallback(this.mPrinterHandle, this);
            }
        } else {
            this.nativeSetPtrReceiveEventCallback(this.mPrinterHandle, null);
            this.mReceiveListener = null;
            this.mJobReceiveListener = null;
        }
    }

    @Override
    protected void nativeOnPtrBatteryLow(String ipAddress, String deviceId) {
        this.onPtrBatteryLow(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrBatteryOk(String ipAddress, String deviceId) {
        this.onPtrBatteryOk(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrBatteryStatusChange(String ipAddress, String deviceId, int battery) {
        this.onPtrBatteryStatusChange(ipAddress, deviceId, battery);
    }

    @Override
    protected void nativeOnPtrCoverOk(String ipAddress, String deviceId) {
        this.onPtrCoverOk(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrCoverOpen(String ipAddress, String deviceId) {
        this.onPtrCoverOpen(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrDrawerClosed(String ipAddress, String deviceId) {
        this.onPtrDrawerClosed(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrDrawerOpen(String ipAddress, String deviceId) {
        this.onPtrDrawerOpen(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrOffline(String ipAddress, String deviceId) {
        this.onPtrOffline(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrOnline(String ipAddress, String deviceId) {
        this.onPtrOnline(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrPaperEnd(String ipAddress, String deviceId) {
        this.onPtrPaperEnd(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrPaperNearEnd(String ipAddress, String deviceId) {
        this.onPtrPaperNearEnd(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrPaperOk(String ipAddress, String deviceId) {
        this.onPtrPaperOk(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrPowerOff(String ipAddress, String deviceId) {
        this.onPtrPowerOff(ipAddress, deviceId);
    }

    @Override
    protected void nativeOnPtrReceive(String ipAddress, String deviceId, int success, int code, int status, int battery, String printJobId) {
        if (this.mJobReceiveListener != null) {
            this.onPtrReceive(ipAddress, deviceId, success, code, status, battery, printJobId);
        } else {
            this.onPtrReceive(ipAddress, deviceId, success, code, status, battery);
        }
    }

    @Override
    protected void nativeOnPtrStatusChange(String ipAddress, String deviceId, int status) {
        this.onPtrStatusChange(ipAddress, deviceId, status);
    }

    protected abstract void outputLogCallFunction(String var1, Object ... var2);

    protected abstract void outputLogReturnFunction(String var1, Object ... var2);

    protected abstract void outputException(String var1, Exception var2);

    protected abstract void outputLogEvent(String var1, Object ... var2);
}

