package com.gingersoft.gsa.cloud.base.utils;

import android.graphics.Color;

import androidx.annotation.ColorInt;

/**
 * @author : bin
 * @create date: 2020-11-03
 * @update date: 2020-11-03
 * @description:
 */
public class ColorUtil {

    private ColorUtil() {
    }

    public static String parseColorInt(@ColorInt int color) {
        return String.format("#%06X", 0xFFFFFF & color);
    }

    public static boolean isColdColor(@ColorInt int color) {
        float[] hsv = new float[3];
        Color.colorToHSV(color, hsv);
        return hsv[2] <= 0.8f;
    }
}
