package com.gingersoft.gsa.cloud.base.utils.time;

import android.content.Context;
import android.graphics.Color;
import android.view.View;

import androidx.core.content.ContextCompat;

import com.bigkoo.pickerview.listener.OnTimeSelectListener;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.ui.view.timeselect.TimePickerView;
import com.gingersoft.gsa.cloud.ui.view.timeselect.builder.TimePickerBuilder;

import java.util.Calendar;

/**
 * Created by Wyh on 2020/2/28.
 * 時間選擇工具類
 */
public class TimePickerUtils {

    /**
     * 顯示報表頁面時間選擇樣式
     *
     * @param mContext
     * @param defaultTime          默認選中時間
     * @param onTimeSelectListener 選中時間回調
     */
    public static TimePickerView showReportTimePicker(Context mContext, Calendar defaultTime, OnTimeSelectListener onTimeSelectListener) {
        //獲取今年第一天的日期
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_YEAR, cal.getActualMinimum(Calendar.DAY_OF_YEAR));
        //打開時間選擇器
        TimePickerView pvTime = new TimePickerBuilder(mContext, onTimeSelectListener)
                .setType(new boolean[]{true, true, true, false, false, false})//默认全部显示
                .setCancelText("取消")//取消按钮文字
                .setSubmitText("確認")//确认按钮文字
                .setContentTextSize(20)//滚轮文字大小
                .setTitleSize(20)//标题文字大小
//                        .setTitleText("请选择时间")//标题文字
                .setOutSideCancelable(true)//点击屏幕，点在控件外部范围时，是否取消显示
                .isCyclic(false)//是否循环滚动
                .setTextColorCenter(Color.BLACK)//设置选中项的颜色
                .setTitleColor(Color.BLACK)//标题文字颜色
                .setSubmitColor(Color.BLUE)//确定按钮文字颜色
                .setCancelColor(Color.BLUE)//取消按钮文字颜色
//                        .setTitleBgColor(0xFF666666)//标题背景颜色 Night mode
//                        .setBgColor(0xFF333333)//滚轮背景颜色 Night mode
//                        .setDate(selectedDate)// 如果不设置的话，默认是系统时间*/
                .setRangDate(cal, Calendar.getInstance())//時間是今年第一天到今天
                .setLabel("", "", "", "", "", "")
                .isCenterLabel(false) //是否只显示中间选中项的label文字，false则每项item全部都带有label。
//                        .isDialog(true)//是否显示为对话框样式
                .build();
        //設置默認選中時間
        pvTime.setDate(defaultTime);//注：根据需求来决定是否使用该方法（一般是精确到秒的情况），此项可以在弹出选择器的时候重新设置当前时间，避免在初始化之后由于时间已经设定，导致选中时间与当前时间不匹配的问题。
        pvTime.show();
        return pvTime;
    }

    /**
     * @param mContext
     * @param startTime            開始時間
     * @param endTime              結束時間
     * @param defaultTime          默認選中時間
     * @param onTimeSelectListener 選中時間後點擊確認 回調
     * @return
     */
    public static TimePickerView showReportTimePicker(Context mContext, Calendar startTime, Calendar endTime, Calendar defaultTime, OnTimeSelectListener onTimeSelectListener) {
        //獲取今年第一天的日期
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_YEAR, cal.getActualMinimum(Calendar.DAY_OF_YEAR));

        //打開時間選擇器
        TimePickerView pvTime = new TimePickerBuilder(mContext, onTimeSelectListener)
                .setType(new boolean[]{true, true, true, false, false, false})
                .setCancelText("取消")//取消按钮文字
                .setSubmitText("確認")//确认按钮文字
                .setContentTextSize(20)//滚轮文字大小
                .setTitleSize(20)//标题文字大小
//                        .setTitleText("请选择时间")//标题文字
                .setOutSideCancelable(true)//点击屏幕，点在控件外部范围时，是否取消显示
                .isCyclic(false)//是否循环滚动
                .setTextColorCenter(Color.BLACK)//设置选中项的颜色
                .setTitleColor(Color.BLACK)//标题文字颜色
                .setSubmitColor(Color.BLUE)//确定按钮文字颜色
                .setCancelColor(Color.BLUE)//取消按钮文字颜色
//                        .setTitleBgColor(0xFF666666)//标题背景颜色 Night mode
//                        .setBgColor(0xFF333333)//滚轮背景颜色 Night mode
//                        .setDate(selectedDate)// 如果不设置的话，默认是系统时间*/
                .setRangDate(startTime, endTime)//時間是今年第一天到今天
                .setLabel("", "", "", "", "", "")
                .isCenterLabel(false) //是否只显示中间选中项的label文字，false则每项item全部都带有label。
//                        .isDialog(true)//是否显示为对话框样式
                .build();
        //設置默認選中時間
        pvTime.setDate(defaultTime);//注：根据需求来决定是否使用该方法（一般是精确到秒的情况），此项可以在弹出选择器的时候重新设置当前时间，避免在初始化之后由于时间已经设定，导致选中时间与当前时间不匹配的问题。
        pvTime.show();
        return pvTime;
    }

    public static TimePickerView showDatePicker(Context mContext, OnTimeSelectListener onTimeSelectListener) {
        //獲取今年第一天的日期
        //打開時間選擇器
        TimePickerView pvTime = new TimePickerBuilder(mContext, onTimeSelectListener)
                .setType(new boolean[]{true, true, true, false, false, false})//默认全部显示
                .setCancelText("取消")//取消按钮文字
                .setSubmitText("確認")//确认按钮文字
                .setContentTextSize(20)//滚轮文字大小
                .setTitleSize(20)//标题文字大小
                .setOutSideCancelable(true)//点击屏幕，点在控件外部范围时，是否取消显示
                .isCyclic(false)//是否循环滚动
                .setTextColorCenter(Color.BLACK)//设置选中项的颜色
                .setTitleColor(Color.BLACK)//标题文字颜色
                .setSubmitColor(Color.BLUE)//确定按钮文字颜色
                .setCancelColor(Color.BLUE)//取消按钮文字颜色
                .setLabel("", "", "", "", "", "")
                .isCenterLabel(false) //是否只显示中间选中项的label文字，false则每项item全部都带有label。
                .build();
        //設置默認選中時間
        pvTime.setDate(Calendar.getInstance());//注：根据需求来决定是否使用该方法（一般是精确到秒的情况），此项可以在弹出选择器的时候重新设置当前时间，避免在初始化之后由于时间已经设定，导致选中时间与当前时间不匹配的问题。
        pvTime.show();
        return pvTime;
    }

    public static TimePickerView showDatePicker(Context mContext, View view, OnTimeSelectListener onTimeSelectListener) {
        //獲取今年第一天的日期
        //打開時間選擇器
        TimePickerView pvTime = new TimePickerBuilder(mContext, onTimeSelectListener)
                .setType(new boolean[]{true, true, true, false, false, false})//默认全部显示
                .setCancelText("取消")//取消按钮文字
                .setSubmitText("確認")//确认按钮文字
                .setContentTextSize(20)//滚轮文字大小
                .setTitleSize(20)//标题文字大小
                .setOutSideCancelable(true)//点击屏幕，点在控件外部范围时，是否取消显示
                .isCyclic(false)//是否循环滚动
                .setTextColorCenter(Color.BLACK)//设置选中项的颜色
                .setTitleColor(Color.BLACK)//标题文字颜色
                .setSubmitColor(Color.BLUE)//确定按钮文字颜色
                .setCancelColor(Color.BLUE)//取消按钮文字颜色
                .setLabel("", "", "", "", "", "")
                .isCenterLabel(false) //是否只显示中间选中项的label文字，false则每项item全部都带有label。
                .build();
        //設置默認選中時間
        pvTime.setDate(Calendar.getInstance());//注：根据需求来决定是否使用该方法（一般是精确到秒的情况），此项可以在弹出选择器的时候重新设置当前时间，避免在初始化之后由于时间已经设定，导致选中时间与当前时间不匹配的问题。
        pvTime.show(view);
        return pvTime;
    }

    /**
     * 顯示報表頁面時間選擇樣式
     *
     * @param mContext
     * @param defaultTime          默認選中時間
     * @param onTimeSelectListener 選中時間回調
     */
    public static com.gingersoft.gsa.cloud.ui.view.timeselect.TimePickerView showTimePicker(Context mContext, Calendar defaultTime, OnTimeSelectListener onTimeSelectListener) {
        //獲取今年第一天的日期
        Calendar endTime = Calendar.getInstance();
        endTime.set(Calendar.HOUR_OF_DAY, endTime.getActualMaximum(Calendar.HOUR_OF_DAY));
        endTime.set(Calendar.MINUTE, endTime.getActualMaximum(Calendar.MINUTE));
        //打開時間選擇器
        com.gingersoft.gsa.cloud.ui.view.timeselect.TimePickerView pvTime = new com.gingersoft.gsa.cloud.ui.view.timeselect.builder.TimePickerBuilder(mContext, onTimeSelectListener)
                .setType(new boolean[]{false, false, false, true, true, false})//默认全部显示
                .setCancelText("取消")//取消按钮文字
                .setSubmitText("確認")//确认按钮文字
                .setContentTextSize(20)//滚轮文字大小
                .setTitleSize(20)//标题文字大小
                .setOutSideCancelable(true)//点击屏幕，点在控件外部范围时，是否取消显示
                .isCyclic(false)//是否循环滚动
                .setTextColorCenter(Color.BLACK)//设置选中项的颜色
                .setTitleColor(Color.BLACK)//标题文字颜色
                .setSubmitColor(Color.BLUE)//确定按钮文字颜色
                .setCancelColor(Color.BLUE)//取消按钮文字颜色
                .setDate(defaultTime)
                .setRangDate(Calendar.getInstance(), endTime)//限制時間範圍
                .setLabel("", "", "", "", "", "")
                .isCenterLabel(false) //是否只显示中间选中项的label文字，false则每项item全部都带有label。
                .build();
        pvTime.show();
        return pvTime;
    }

    private static TimePickerBuilder timePickerBuilder;

    public static TimePickerBuilder init(Context context, OnTimeSelectListener onTimeSelectListener) {
        timePickerBuilder = new TimePickerBuilder(context, onTimeSelectListener)
                .setCancelText("取消")
                .setSubmitText("確認")
                .setContentTextSize(20)
                .setTitleSize(20)
                .setOutSideCancelable(true)
                .isCyclic(false)
                .setTextColorCenter(Color.BLACK)
                .setTitleColor(Color.BLACK)
                .setSubmitColor(ContextCompat.getColor(context, R.color.theme_color))
                .setCancelColor(ContextCompat.getColor(context, R.color.theme_color))
                .setLabel("", "", "", "", "", "")
                .isCenterLabel(false)
                .setDate(Calendar.getInstance());
        return timePickerBuilder;
    }

}
