package com.gingersoft.gsa.cloud.config.globalconfig.applyOptions;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.BuildConfig;
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.intercept.HeadersInterceptor;
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.intercept.LoggingInterceptor;
import com.jess.arms.di.module.ClientModule;

import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;


public class MyRetrofitConfiguration implements ClientModule.RetrofitConfiguration {
    @Override
    public void configRetrofit(Context context, Retrofit.Builder builder) {
        // 配置多BaseUrl支持
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        clientBuilder.addInterceptor(new HeadersInterceptor());//使用自定义User-Agent
        if (BuildConfig.DEBUG) {
            clientBuilder.addInterceptor(new LoggingInterceptor());//使用自定义的Log拦截器
        }
        builder.client(RetrofitUrlManager.getInstance().with(clientBuilder).build());
    }
}
