package com.gingersoft.gsa.cloud.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class ListSelectAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    private int textSize;

    private int selectTextColor;
    private int normalTextColor;

    private Drawable normalBg;
    private Drawable selectBg;

    private int selectIndex = 0;
    private int paddingLeft = 0;
    private int paddingTop = 0;
    private int paddingRight = 0;
    private int paddingBottom = 0;
    private Context mContext;

    public ListSelectAdapter(Context context, int layoutResId, @Nullable List<String> data) {
        super(layoutResId, data);
        this.mContext = context;
        textSize = 16;
        selectBg = ContextCompat.getDrawable(context, R.drawable.s_tran_twenty_blue);
        selectTextColor = ContextCompat.getColor(context, R.color.other_order_details_sure_btn_color);
        normalTextColor = ContextCompat.getColor(context, R.color.color_c9);
    }

    public ListSelectAdapter(Context context, @Nullable List<String> data) {
        super(R.layout.item_list_string_select, data);
        this.mContext = context;
        textSize = 16;
        selectBg = ContextCompat.getDrawable(context, R.drawable.s_tran_twenty_blue);
        selectTextColor = ContextCompat.getColor(context, R.color.other_order_details_sure_btn_color);
        normalTextColor = ContextCompat.getColor(context, R.color.color_c9);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, String s) {
        TextView title = baseViewHolder.getView(R.id.cb_select_title);
        title.setText(s);
        title.setTextSize(textSize);
        title.setBackground(selectBg);
        title.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        if (baseViewHolder.getAdapterPosition() == selectIndex) {
            title.setBackground(selectBg);
            title.setTextColor(selectTextColor);
        } else {
            title.setBackground(normalBg);
            title.setTextColor(normalTextColor);
        }
    }

    public ListSelectAdapter setSelectTextColor(int textColor) {
        this.selectTextColor = textColor;
        return this;
    }

    public ListSelectAdapter setNormalTextColor(int textColor) {
        this.normalTextColor = textColor;
        return this;
    }

    public ListSelectAdapter setTextSize(int textSize) {
        this.textSize = textSize;
        return this;
    }

    public ListSelectAdapter setNormalBg(Drawable bg) {
        this.normalBg = bg;
        return this;
    }

    public ListSelectAdapter setSelectBg(Drawable bg) {
        this.selectBg = bg;
        return this;
    }

    public ListSelectAdapter setNormalBg(int bg) {
        return setNormalBg(ContextCompat.getDrawable(mContext, bg));
    }

    public ListSelectAdapter setSelectBg(int bg) {
        return setSelectBg(ContextCompat.getDrawable(mContext, bg));
    }

    public ListSelectAdapter setDefaultSelect(int select) {
        this.selectIndex = select;
        return this;
    }

    public ListSelectAdapter setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingBottom = paddingBottom;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        return this;
    }

    public ListSelectAdapter notifyAdapter() {
        notifyDataSetChanged();
        return this;
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
        notifyAdapter();
    }
}
