package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.utils.AppDialog;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:58
 * Use:
 */
public class SelectDialogProvider<T extends InfoMultiBean> extends MyBaseItemProvider<T> {

    private Context context;
    private List<InfoMultiBean> infoMultiBeans;
    private int lastSelect = 0;
    //當前佈局在adapter中的下標
    private int currentPosition = -1;

    public SelectDialogProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_TYPE_SHOW_DIALOG;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_select_dialog;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, InfoMultiBean infoMultiBean) {
        super.convert(baseViewHolder, infoMultiBean);
        currentPosition = baseViewHolder.getAdapterPosition();
        infoMultiBeans = infoMultiBean.getInfoMultiBeans();
        if (lastSelect == 0) {
            for (int i = 0; i < infoMultiBeans.size(); i++) {
                if (infoMultiBeans.get(i).isChecked()) {
                    lastSelect = i;
                }
            }
        }
        TextView tvValue = baseViewHolder.getView(R.id.tv_provider_select_text);
        if (infoMultiBeans != null) {
            tvValue.setText(infoMultiBeans.get(lastSelect).getShowTitle());
            infoMultiBeans.get(lastSelect).setChecked(true);
        }
        tvValue.setOnClickListener(mOnClickListener);
        baseViewHolder.getView(R.id.iv_provider_select).setOnClickListener(mOnClickListener);
    }

    View.OnClickListener mOnClickListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            if (infoMultiBeans != null) {
                List<String> list = new ArrayList<>();
                int defaultCheck = 0;
                for (int i = 0; i < infoMultiBeans.size(); i++) {
                    list.add(infoMultiBeans.get(i).getShowTitle());
                    if (infoMultiBeans.get(i).isChecked()) {
                        defaultCheck = i;
                    }
                }
                lastSelect = defaultCheck;
                new AppDialog().showSelectDialog(context, "單位種類", list, defaultCheck, (view, dialog, position) -> {
                    if (view.getId() == R.id.tv_delivery_confirm) {
                        infoMultiBeans.get(lastSelect).setChecked(false);
                        infoMultiBeans.get(position).setChecked(true);
                        lastSelect = position;
                        getAdapter().notifyItemChanged(currentPosition);
                    }
                    dialog.dismiss();
                });
            }
        }
    };
}
