package com.gingersoft.coldchain_module.mvp.contract;

import com.gingersoft.coldchain_module.mvp.model.bean.CancelLogisticsBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ReadBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ShipAnyOrdersNewBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateOrderStatusBean;
import com.gingersoft.gsa.cloud.bean.PublicBean;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.io.File;

import io.reactivex.Observable;
import okhttp3.RequestBody;


public interface OrderDetailsContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadOrderDetails(OrderDetails.DataBean bean);

        void printLogisticsList(File file);

        void updateOrderState(int state);

        void setPrintPdfState();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<OrderDetails> findOrderDetails(RequestBody requestBody);

        Observable<ShipAnyOrdersNewBean> thirdDelivery(RequestBody requestBody);

        Observable<UpdateOrderStatusBean> updateOrderStatus(RequestBody requestBody);

        Observable<CancelLogisticsBean> cancelLogistics(RequestBody requestBody);

        Observable<ReadBean> setIsRead(RequestBody requestBody);

        Observable<String> addPrj(RequestBody requestBody);

        Observable<PublicBean> updatePrintPdfStatus(RequestBody requestBody);
    }
}
