package com.gingersoft.coldchain_module.mvp.model;

import android.app.Application;

import com.gingersoft.coldchain_module.mvp.contract.SupplementOrderContract;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementInfoBean;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementResultBean;
import com.gingersoft.coldchain_module.mvp.model.service.ColdChainService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


@ActivityScope
public class SupplementOrderModel extends BaseModel implements SupplementOrderContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public SupplementOrderModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<SupplementInfoBean> getNumByOrderType(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).getNumByOrderType(requestBody);
    }

    @Override
    public Observable<SupplementResultBean> submitOrder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).submitOrder(requestBody);
    }
}