package com.gingersoft.gsa.delivery_pick_mode.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.delivery_pick_mode.R;
import com.gingersoft.gsa.delivery_pick_mode.mvp.model.MemberAddressInfoBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

public class AddressAdapter extends BaseQuickAdapter<MemberAddressInfoBean.DataBean, BaseViewHolder> {

    public AddressAdapter(List<MemberAddressInfoBean.DataBean> dataBeanList) {
        super(R.layout.layout_shipping_address, dataBeanList);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, MemberAddressInfoBean.DataBean dataBean) {
        String title = dataBean.getReceiver();
        if (dataBean.getSex() == 1) {
            title += "  先生";
        } else {
            title += "  女士";
        }
        title += "  " + dataBean.getPhone();
        baseViewHolder.setText(R.id.tv_shipping_receiver, title);
        baseViewHolder.setText(R.id.tv_shipping_address, dataBean.getCurrentAddress());
    }
}
