package com.gingersoft.gsa.delivery_pick_mode.ui.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.gingersoft.gsa.cloud.print.bean.OrderDetails
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.FoodDetailsTranBean
import com.gingersoft.gsa.delivery_pick_mode.databinding.LayoutDialogFoodItemBinding
import com.qmuiteam.qmui.util.QMUIDisplayHelper.dp2px

class FoodListAdapter(private val context: Context, private val productnameBeans: List<OrderDetails.DataBean.PRODUCTNAMEBean>) : RecyclerView.Adapter<FoodListAdapter.ViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.layout_dialog_food_item, parent, false))
    }

    override fun getItemCount(): Int {
        return productnameBeans.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.binding.data = FoodDetailsTranBean.FoodDetails.getByPRODUCTNAMEBean(productnameBeans[position])
        holder.binding.price = productnameBeans[position].PRICE!!.toFloat()
        if (productnameBeans[position].child != null) {
            if (productnameBeans[position].child!!.isNotEmpty()) {
                for (child in productnameBeans[position].child!!) {
                    val foodChild = getChild(FoodDetailsTranBean.FoodDetails.getByChildBeanX(child), 10)
                    val content = foodChild.findViewById<LinearLayout>(R.id.layout_food_content)
                    if (child.child != null) {
                        if (child.child!!.isNotEmpty()) {
                            for (childBean in child.child!!) {
                                content.addView(getChild(FoodDetailsTranBean.FoodDetails.getByChildBean(childBean), 20))
                            }
                        }
                    }
                    holder.content.addView(foodChild)
                }
            }
        }
    }

    private fun getChild(child: FoodDetailsTranBean, leftMargin: Int): View {
        val foodChildChild = LayoutInflater.from(context).inflate(R.layout.layout_dialog_food_item, null, false)
        val childBinding: LayoutDialogFoodItemBinding = DataBindingUtil.bind(foodChildChild)!!
        childBinding.data = child
        childBinding.price = child.PRICE!!.toFloat()

        val childNext = foodChildChild.findViewById<ImageView>(R.id.iv_food_item_next)
        childNext.visibility = View.VISIBLE

//        val childParams = childNext.layoutParams as ConstraintLayout.LayoutParams
        childNext.setPadding(dp2px(context, leftMargin), 0, 0, 0)
//        childNext.layoutParams = childParams
        return foodChildChild
    }


    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var binding: LayoutDialogFoodItemBinding = DataBindingUtil.bind(itemView)!!
        val content: LinearLayout = itemView.findViewById(R.id.layout_food_content)
    }
}