package com.gingersoft.gsa.delivery_pick_mode.ui.base

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog
import com.jess.arms.base.BaseActivity
import com.jess.arms.di.component.AppComponent
import com.jess.arms.mvp.BasePresenter
import com.jess.arms.mvp.IModel
import com.jess.arms.mvp.IPresenter
import com.jess.arms.mvp.IView

open class BaseActivity<P : IPresenter> : BaseActivity<P>() {

    fun showLoading(message: String? = null) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true)
        else
            LoadingDialog.showDialogForLoading(this)
    }

    fun cancelDialogForLoading() {
        LoadingDialog.cancelDialogForLoading()
    }

    override fun setupActivityComponent(appComponent: AppComponent) {
    }

    override fun initView(savedInstanceState: Bundle?): Int {
        return 0
    }

    override fun initData(savedInstanceState: Bundle?) {
    }

    override fun initIntent() {
    }

    override fun initTopBar() {
    }

    override fun initLanguage() {
    }

    override fun initLayoutParams() {
    }

    override fun initLayoutVisible() {
    }

}