package com.gingersoft.gsa.cloud.download.mvp.model.service;

import com.gingersoft.gsa.cloud.base.Api;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.FoodBean;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.ComboItemRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FoodComboRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FoodModifierRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FunctionRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.ModifierRespone;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import retrofit2.http.GET;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2019/12/20.
 */
public interface DownloadService {

    @GET("user/resource/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FunctionRespone> downFunctionList(@Query("userId") long userId);

    @GET(Api.food_list + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodBean> downFoodList(@Query("restaurantId") int restaurantId);

    @GET(Api.modifier + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<ModifierRespone> downModifier(@Query("restaurantId") int restaurantId);

    @GET(Api.food_package_relation + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodComboRespone> downFoodCombo(@Query("restaurantId") int restaurantId);

    @GET(Api.food_comboItem + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<ComboItemRespone> downComboItem(@Query("restaurantId") int restaurantId);

    @GET(Api.food_modifiere_relation + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodModifierRespone> downFoodModifier(@Query("restaurantId") int restaurantId);

    @GET(Api.restaurant_discount + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> downDiscount(@Query("restaurantId") int restaurantId);

    @GET(Api.expand_info + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> downExpandInfo(@Query("restaurantId") int restaurantId);

    @GET(Api.printerDevice_list + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> downPrinterList(@Query("restaurantId") int restaurantId);

    @GET(Api.color_list + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> downColorList();

}
