package com.gingersoft.gsa.cloud.main.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.main.di.module.ShellModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.ShellContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu.ShellActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/03/2020 16:32
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = ShellModule.class, dependencies = AppComponent.class)
public interface ShellComponent {
    void inject(ShellActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        ShellComponent.Builder view(ShellContract.View view);

        ShellComponent.Builder appComponent(AppComponent appComponent);

        ShellComponent build();
    }
}