package com.gingersoft.gsa.cloud.main.mvp.contract;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodGroupBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SummaryBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.TimePeriodBean;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;

import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/03/2020 11:07
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface EditFoodContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadInfoList(List<FoodGroupBean> foodGroupBeans);

        void setTimePeriodClick(List<TimePeriodBean> timePeriodBeans);

        void setSummaryClick(List<SummaryBean> summaryBeans);

        void deleteByPosition(int position);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<BaseResult> getPeriodList(int brandId);

        /**
         * 刪除時段
         * @param id 時段id
         * @return
         */
        Observable<BaseResult> deletePeriod(int id);

        /**
         * 獲取餐種列表
         * @param restaurantId 餐廳id
         * @return
         */
        Observable<BaseResult> getSummaryList(int restaurantId);

        /**
         * 刪除餐種
         * @param id 餐種id
         * @return
         */
        Observable<BaseResult> deleteSummary(int id);
    }
}
