package com.gingersoft.gsa.cloud.main.mvp.contract;

import com.gingersoft.gsa.cloud.main.mvp.model.bean.DailyReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DeliveryLineChartBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DeliveryPersonnelReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SalesFoodsBean;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/23/2020 16:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface SalesContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadInfo(List<SalesFoodsBean.DataBean.SalesRankingBean> salesRanking);

        void loadDeliveryPersonnelReport(List<DailyReportBean> dailyReportBeans);

        void loadDeliveryLineChart(List<DeliveryLineChartBean.DataBean> data);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<SalesFoodsBean> getSalesReportInfo(Map<String, Object> map);

        Observable<SalesFoodsBean> getSalesReportInfo(RequestBody requestBody);

        Observable<DeliveryLineChartBean> getDeliveryOrderCurveInfo(Map<String, Object> map);

        Observable<DeliveryPersonnelReportBean> getDeliveryPersonnelReport(Map<String, Object> map);

    }
}
