package com.gingersoft.gsa.cloud.main.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.main.mvp.contract.QrCodeContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.RestaurantQrBean;
import com.gingersoft.gsa.cloud.main.mvp.model.service.MainService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;


@ActivityScope
public class QrCodeModel extends BaseModel implements QrCodeContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public QrCodeModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<RestaurantQrBean> getRestaurantQrCode(String restaurantId) {
        return mRepositoryManager.obtainRetrofitService(MainService.class).getRestaurantQrCode(restaurantId);
    }
}