package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.util.TypedValue;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerReportComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.ReportContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.ReportPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.BusinessReportFragment;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.PaymentMethodReportFragment;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.SalesFragment;
import com.gingersoft.gsa.cloud.ui.adapter.TabFragmentAdapter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.google.android.material.tabs.TabLayout;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/23/2020 16:18
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 * 報表頁面
 */
public class ReportActivity extends BaseFragmentActivity<ReportPresenter> implements ReportContract.View {
    @BindView(R2.id.report_topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.table_layout)
    TabLayout mTabLayout;
    @BindView(R2.id.report_viewpager)
    ViewPager mViewPager;

    private TabFragmentAdapter mTabFragmentAdapter;
    private List<String> titles;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerReportComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_report; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTitlte();
        initViewPager();
    }

    /**
     * 设置顶部数据
     */
    private void initTitlte() {
        titles = new ArrayList<>();
        titles.add("營業分析");
        titles.add("銷售分析");
        titles.add("支付分析");

        List<Fragment> mFragments = new ArrayList<>();
        mFragments.add(BusinessReportFragment.newInstance());
        mFragments.add(SalesFragment.newInstance());
        mFragments.add(PaymentMethodReportFragment.newInstance());
        //实例化适配器
        mTabFragmentAdapter = new TabFragmentAdapter(getSupportFragmentManager(), 1);
        //设置加载的Fragment集合
        mTabFragmentAdapter.setFragments(mFragments);
    }

    /**
     * 设置Viewpager的适配器
     */
    private void initViewPager() {
        //设置Viewpager的适配器
        mViewPager.setAdapter(mTabFragmentAdapter);
        mTabLayout.setupWithViewPager(mViewPager);//TabLayout绑定ViewPager
        mTabLayout.setTabsFromPagerAdapter(mTabFragmentAdapter);//TabLayout的标签从Adapter中获取
        //用来循环适配器中的视图总数
        for (int i = 0; i < mTabFragmentAdapter.getCount(); i++) {
            //获取每一个tab对象
            TabLayout.Tab tabAt = mTabLayout.getTabAt(i);
            if (tabAt != null) {
                //将每一个条目设置我们自定义的视图
                tabAt.setCustomView(R.layout.layout_table_item);
                //默认选中第一个
                if (i == 0) {
                    // 设置第一个tab的TextView是被选择的样式
                    setSelectTab(tabAt, true);
                }
                //通过tab对象找到自定义视图的ID
                TextView textView = tabAt.getCustomView().findViewById(R.id.tv_tab);
                textView.setText(titles.get(i));//设置tab上的文字
            }
        }

        mTabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                setSelectTab(tab, true);
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {
                setSelectTab(tab, false);
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
    }

    private void setSelectTab(TabLayout.Tab tabAt, boolean isSelected) {
        if (tabAt.getCustomView() != null) {
            TextView tab = tabAt.getCustomView().findViewById(R.id.tv_tab);//第一个tab被选中
            tab.setSelected(isSelected);
            //设置选中标签的文字大小
            tab.setTextSize(TypedValue.COMPLEX_UNIT_PX, isSelected ? getResources().getDimensionPixelSize(R.dimen.sp_16) : getResources().getDimensionPixelSize(R.dimen.sp_14));
            tab.getPaint().setFakeBoldText(isSelected);
        }
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBar.setTitle("報表");
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
