package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionNormalItem;
import com.gingersoft.gsa.cloud.main.mvp.ui.view.HomeFunctionHead;
import com.qmuiteam.qmui.widget.section.QMUIDefaultStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;

import androidx.annotation.NonNull;
import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * Created by Wyh on 2020/1/10.
 */
public class HomeFunctionAdapter extends QMUIDefaultStickySectionAdapter<SectionHeader, SectionNormalItem> {

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionHeaderViewHolder(@NonNull ViewGroup viewGroup) {
        return new QMUIStickySectionAdapter.ViewHolder(new HomeFunctionHead(viewGroup.getContext()));
    }

    @NonNull
    @Override
    protected ViewHolder onCreateSectionItemViewHolder(@NonNull ViewGroup viewGroup) {
        return new ViewHolder(View.inflate(viewGroup.getContext(), R.layout.main_home_funcation_item, null));
    }

    @Override
    protected void onBindSectionHeader(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, SectionNormalItem> section) {
        super.onBindSectionHeader(holder, position, section);
        HomeFunctionHead itemView = (HomeFunctionHead) holder.itemView;
        itemView.render(section.getHeader(), section.isFold());
    }

    @Override
    protected void onBindSectionItem(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, SectionNormalItem> section, int itemIndex) {
        super.onBindSectionItem(holder, position, section, itemIndex);
        ViewHolder viewHolder = (ViewHolder) holder;
        viewHolder.ivFun.setImageResource(section.getItemAt(itemIndex).getImage());
        viewHolder.tvFun.setText(section.getItemAt(itemIndex).getText());
    }

    public class ViewHolder extends QMUIStickySectionAdapter.ViewHolder {
        @BindView(R2.id.iv_main_home_item_function_icon)
        ImageView ivFun;//功能圖標
        @BindView(R2.id.tv_main_home_item_function_name)
        TextView tvFun;//功能名
        public ViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }

        public TextView getTvFun() {
            return tvFun;
        }
    }
}
