package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem3;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import java.util.List;
import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class SettlementReportItemAdapter extends DefaultAdapter<SectionTextItem3> {

    private Context mContext;

    public SettlementReportItemAdapter(Context context, List<SectionTextItem3> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<SectionTextItem3> getHolder(View v, int viewType) {
        return new SettlementReportItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.item_settlement_report;
    }

    class SettlementReportItemHolder extends BaseHolder<SectionTextItem3> {

        @BindView(R2.id.tv_left)
        TextView tv_left;
        @BindView(R2.id.tv_center)
        TextView tv_center;
        @BindView(R2.id.tv_right)
        TextView tv_right;

        public SettlementReportItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(SectionTextItem3 reportItem, int position) {

            tv_left.setText(reportItem.getLeftText());
            tv_center.setText(reportItem.getCenterText());
            tv_right.setText(reportItem.getRightText());

        }
    }
}
