package com.gingersoft.gsa.cloud.manager.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.manager.di.module.AreaListModule;
import com.gingersoft.gsa.cloud.manager.mvp.contract.AreaListContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.AreaListFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/19/2020 12:26
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = AreaListModule.class, dependencies = AppComponent.class)
public interface AreaListComponent {
    void inject(AreaListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        AreaListComponent.Builder view(AreaListContract.View view);

        AreaListComponent.Builder appComponent(AppComponent appComponent);

        AreaListComponent build();
    }
}