package com.gingersoft.order_advance_module.di.module;

import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;

import com.gingersoft.order_advance_module.mvp.contract.DiningTableContract;
import com.gingersoft.order_advance_module.mvp.model.DiningTableModel;


@Module
public class DiningTableModule {
    private DiningTableContract.View view;

    /**
     * 构建DiningTableModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public DiningTableModule(DiningTableContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    DiningTableContract.View provideDiningTableView() {
        return this.view;
    }

    @ActivityScope
    @Provides
    DiningTableContract.Model provideDiningTableModel(DiningTableModel model) {
        return model;
    }
}