package com.gingersoft.gsa.cloud.base.order.bean.discount;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-12
 * 修订历史：2020-09-12
 * 描述：优惠券折扣实体
 */
@Data
public class CouponDiscountBean {

    private Long id;
    // 店鋪ID
    private Long restaurantId;
    // 品牌ID
    private Long brandId;
    // 會員卡類型名稱
    private String couponTypeName1;
    // 會員卡類型名稱1
    private String couponTypeName2;
    private String couponTypeName3;
    // 優惠券的有效開始日期
    private String beginDate;
    // 優惠券的有效期結束日期
    private String endDate;
    // 有效天數
    private Integer periodDays;
    // 會員卡有效期
    private String periodDate;
    // 使用次數上限
    private Integer upperLimitTimes;
    // 卡類型：1折扣，2現金券
    private Byte couponType;
    // 卡規則狀態：0正常，1失效
    private Byte status;
    // 單詞消費上限金額// BigDecimal
    private Double billMinAmount;
    // 同一個訂單同一規則券的使用次數，小於等於1=只可用1次, 大於1=無限次
    private Integer samebillLimitTimes;
    // 是否獨佔 0否，1是
    private Byte exclusive;
    // 是否免費服務 0否，1是
    private Byte xSc;
    // 卡面值
    private double amount;
    // 卡折扣比列  8折：20'
    private int discount;
    // 備註
    private String remark;
    // 是否免會員積分 0否，1是
    private Byte xPoints;
    // 優惠券使用類型：1 不限制，2 app外賣,3 gspos，4外賣自取
    private Byte usageType;
    // 1 常規劵   2 無庫存劵3.口令領取
    private Byte isType;
    // 消費滿
    private Double spend;
    // 是否累計滿減：0否，1是
    private Byte accumulate;

    public String getName(){
        if(!TextUtils.isEmpty(couponTypeName1)) {
            return this.couponTypeName1;
        }
        if(!TextUtils.isEmpty(couponTypeName2)) {
            return this.couponTypeName2;
        }
        if(!TextUtils.isEmpty(couponTypeName3)) {
            return this.couponTypeName3;
        }
        return "";
    }
}
