package com.joe.print.mvp.print;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Wyh on 2020/2/10.
 * 打印工具類
 */
public class PrintUtils {

    //一行42個 17.5
    public final static int lineLength = 42;
    private static int foodNameSpace = 20;
    private static int foodNumSpace = 8;
    private static int foodAmountSpace = 12;
    public final static double BBPOS_Chinese_Length = 2.4;

    /**
     * @param content           要顯示的內容
     * @param maxLength         字符串最大長度
     * @param chineseCharLength 一個中文字符所佔長度
     * @return 按照maxLength長度分割後的string集合
     */
    public static List<String> getFormatList(String content, int maxLength, double chineseCharLength) {
        String chinese = "[\u4e00-\u9fa5]";
        List<String> stringList = new ArrayList<>();
        int length = 0;
        int startIndex = 0;
        for (int i = 0; i < content.length(); i++) {
            String temp = content.substring(i, i + 1);
            //判斷中英文，累積長度
            if (temp.matches(chinese)) {
                length += chineseCharLength;
            } else {
                length += 1;
            }
            if (length > maxLength) {
                i -= 1;
            }
            //長度達到設定的值
            if (length >= maxLength) {
                String headerStr = content.substring(startIndex, i + 1);
                String lastStr = headerStr.substring(headerStr.length() - 1);
                if (!lastStr.matches(chinese)) {
                    //只要不是中文
                    if (headerStr.length() + 1 <= content.length()) {
                        String nextFirstStr = content.substring(headerStr.length(), headerStr.length() + 1);
                        if (!nextFirstStr.matches(chinese)) {
                            //如果截取後最後一個字符是英文，則需要判斷下一個字符是不是英文
                            //是，那麼這是一整個單詞，需要截取整段換到下一行去
                            for (int j = headerStr.length() - 1; j >= 0; j--) {
                                String str = headerStr.charAt(j) + "";
                                if (!str.matches(chinese)) {
                                    //找到不是英文的
                                    String newHeaderStr = headerStr.substring(0, j + 1);
                                    stringList.add(newHeaderStr);
                                    startIndex = i - (headerStr.length() - newHeaderStr.length()) + 1;
                                    length = 0;
                                    i = startIndex;
                                    break;
                                }
                                if (j == 0) {
                                    //循環完了都沒找到，就不管了
                                    stringList.add(headerStr);
                                    startIndex = i + 1;
                                    length = 0;
                                    break;
                                }
                            }
                        } else {
                            stringList.add(headerStr);
                            startIndex = i + 1;
                            length = 0;
                        }
                    } else {
                        stringList.add(headerStr);
                        startIndex = i + 1;
                        length = 0;
                    }
                } else {
                    stringList.add(headerStr);
                    startIndex = i + 1;
                    length = 0;
                }
            } else if (length > 0 && i == content.length() - 1) {
                stringList.add(content.substring(startIndex));
            }
        }
        return stringList;
    }

    /**
     * 獲取縮進，通過文字和最大長度
     *
     * @param text
     * @param maxLength
     * @return
     */
    private static String getSpaceByTextLength(String text, int maxLength, double chineseCharLength) {
        int spaceLength = (int) Math.ceil(maxLength - getChineseValueLength(text, chineseCharLength));
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < spaceLength; i++) {
            space.append(" ");
        }
        space.append(text);
        return space.toString();
    }

    /**
     * 根據字符串獲取長度，中文長度為2，在那台針式打印機長度為1.5
     *
     * @param value
     * @return
     */
    private static double getChineseValueLength(String value, double chineseCharLength) {
        double valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += chineseCharLength;
            } else {
                valueLength += 1;
            }
        }
        return valueLength;
    }

    /**
     * @param name1             字符串一
     * @param name2             字符串二
     * @param name3             字符串三
     * @param chineseCharLength 中文字符所佔長度，BBPOS佔2.4，針式佔1.5
     * @return 返回N行分割好的排版文字
     */
    public static String getLineString(String name1, String name2, String name3, double chineseCharLength) {
        List<String> name1s = getFormatList(name1, foodNameSpace, chineseCharLength);
        List<String> name2s = getFormatList(name2, foodNumSpace, chineseCharLength);
        List<String> name3s = getFormatList(name3, foodAmountSpace, chineseCharLength);

        int maxLine = Math.max(Math.max(name1s.size(), name2s.size()), name3s.size());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < maxLine; i++) {
            stringBuilder.append("<p>");
            putText(chineseCharLength, name1s, stringBuilder, i, foodNameSpace);
            putText(chineseCharLength, name2s, stringBuilder, i, foodNumSpace);
            putText(chineseCharLength, name3s, stringBuilder, i, foodAmountSpace);
            stringBuilder.append("</p>");
        }
        return stringBuilder.toString();
    }

    /**
     * @param name1             字符串一
     * @param name2             字符串二
     * @param chineseCharLength 中文字符所佔長度，BBPOS佔2.4，針式佔1.5
     * @return 返回N行分割好的排版文字
     */
    public static String getLineString(String name1, String name2, double chineseCharLength, int lineWidth) {
        List<String> name1s = getFormatList(name1, lineWidth / 2, chineseCharLength);
        List<String> name2s = getFormatList(name2, lineWidth / 2, chineseCharLength);

        int maxLine = Math.max(name1s.size(), name2s.size());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < maxLine; i++) {
            stringBuilder.append("<p>");
            putText(chineseCharLength, name1s, stringBuilder, i, foodNameSpace);
            putText(chineseCharLength, name2s, stringBuilder, i, foodNumSpace);
            stringBuilder.append("</p>");
        }
        return stringBuilder.toString();
    }

    private static void putText(double chineseCharLength, List<String> name1s, StringBuilder stringBuilder, int i, int foodNameSpace) {
        if (i < name1s.size()) {
            stringBuilder.append(getSpaceByTextLength(name1s.get(i), foodNameSpace, chineseCharLength));
        } else {
            stringBuilder.append(getSpaceByTextLength("", foodNameSpace, chineseCharLength));
        }
    }

}
