package com.joe.print.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.joe.print.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class PrintProgressAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    private int progress = 0;

    public PrintProgressAdapter(@Nullable List<String> data) {
        super(R.layout.print_progress_item, data);

    }

    public void setProgress(int progress) {
        this.progress = progress;
        super.notifyDataSetChanged();
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, String s) {
        baseViewHolder.setText(R.id.tv_print_progressbar, s);
        if (progress > baseViewHolder.getAdapterPosition()) {
            baseViewHolder.setGone(R.id.pb_print_progressbar, true);
            baseViewHolder.setTextColor(R.id.tv_print_progressbar, R.color.order_state0_color);
            baseViewHolder.setGone(R.id.iv_checked, false);
        } else if (progress == baseViewHolder.getAdapterPosition()) {
            baseViewHolder.setGone(R.id.pb_print_progressbar, false);
            baseViewHolder.setTextColor(R.id.tv_print_progressbar, R.color.theme_333_color);
            baseViewHolder.setGone(R.id.iv_checked, true);
        } else {
            baseViewHolder.setGone(R.id.pb_print_progressbar, true);
            baseViewHolder.setTextColor(R.id.tv_print_progressbar, R.color.color_ccc);
            baseViewHolder.setGone(R.id.iv_checked, true);
        }

    }
}
