package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.SupplyChainMainModule;
import com.gingersoft.supply_chain.mvp.contract.SupplyChainMainContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.supply_chain.mvp.ui.activity.SupplyChainMainActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 14:45
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = SupplyChainMainModule.class, dependencies = AppComponent.class)
public interface SupplyChainMainComponent {
    void inject(SupplyChainMainActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        SupplyChainMainComponent.Builder view(SupplyChainMainContract.View view);

        SupplyChainMainComponent.Builder appComponent(AppComponent appComponent);

        SupplyChainMainComponent build();
    }
}