package com.gingersoft.supply_chain.mvp.bean;

import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/2
 * Time: 10:26
 * Use: 食材訂購列表信息
 */
@Data
public class FoodListInfoBean {

    private boolean success;
    private long sysTime;
    private List<DataBean> data;

    @Data
    public static class DataBean {
        //供應商id
        private int id;
        //供應商名稱
        private String supplierName;
        private long createTime;
        //食材集合
        private List<PurchaseFoodListVOSBean> purchaseFoodListVOS;

        /**
         * 食材信息
         */
        @Data
        public static class PurchaseFoodListVOSBean {
            private int id;
            private String supplierName;
            private String images;
            private String foodNo;
            private String name;
            private double unitPrice;
            private int quantityStarts;
            private int quantityEnd;
            private int type;
            private String unitContent;
            private long createTime;
        }
    }
}
