package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.utils.glide.GlideUtils;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.FoodListInfoBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.gingersoft.supply_chain.mvp.ui.fragment.FoodIngredientsFragment.FOOD_INGREDIENTS;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/2
 * Time: 10:05
 * Use: 供應鏈食品列表
 */
public class FoodListAdapter extends BaseQuickAdapter<FoodListInfoBean.DataBean.PurchaseFoodListVOSBean, BaseViewHolder> {
    private Context context;
    /**
     * 編輯或者下單
     * FOOD_INGREDIENTS
     * ADD_ORDER
     */
    private int adapterType;
    /**
     * key 為foodId
     * value 為 food數量
     */
    private Map<Integer, Integer> integerMap;

    public FoodListAdapter(Context context, @Nullable List<FoodListInfoBean.DataBean.PurchaseFoodListVOSBean> data, int adapterType) {
        super(R.layout.item_food_ingredient, data);
        addChildClickViewIds(R.id.iv_supplier_edit, R.id.iv_supplier_delete);
        this.context = context;
        this.adapterType = adapterType;
        integerMap = new HashMap<>(8);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, FoodListInfoBean.DataBean.PurchaseFoodListVOSBean foodInfoBean) {
        viewHolder.setText(R.id.tv_food_item_supplier_name, foodInfoBean.getSupplierName());
        ImageView foodImg = viewHolder.getView(R.id.iv_food_ingredient_img);
//        Glide.with(context).load(foodInfoBean.getImages()).into(foodImg);
        if (TextUtil.isNotEmptyOrNullOrUndefined(foodInfoBean.getImages())) {
            GlideUtils.display(context, foodImg, foodInfoBean.getImages());
        }
        viewHolder.setText(R.id.tv_food_item_no, foodInfoBean.getFoodNo());
        viewHolder.setText(R.id.tv_food_item_name, foodInfoBean.getName());
        viewHolder.setText(R.id.tv_food_item_unit, foodInfoBean.getUnitContent());
        viewHolder.setText(R.id.tv_food_item_price, "$" + foodInfoBean.getUnitPrice());
        if (adapterType == FOOD_INGREDIENTS) {
            viewHolder.setGone(R.id.iv_supplier_edit, false);
            viewHolder.setGone(R.id.iv_supplier_delete, false);
            viewHolder.setGone(R.id.layout_operation_food_num, true);
        } else {
            EditText editText = viewHolder.getView(R.id.ed_food_ingredient_number);
            Integer foodNum = integerMap.get(foodInfoBean.getId());
            if (foodNum == null) {
                editText.setText(String.valueOf(0));
            } else {
                editText.setText(String.valueOf(foodNum));
            }
            viewHolder.setGone(R.id.iv_supplier_edit, true);
            viewHolder.setGone(R.id.iv_supplier_delete, true);
            viewHolder.setGone(R.id.layout_operation_food_num, false);
            viewHolder.getView(R.id.btn_food_operation_sub).setOnClickListener(v -> {
                subNumber(editText, foodInfoBean);
            });

            viewHolder.getView(R.id.btn_food_operation_add).setOnClickListener(v -> {
                addNumber(editText, foodInfoBean);
            });
//            viewHolder.getView(R.id.btn_food_operation_sub).setOnLongClickListener(v -> {
//                ThreadFactory namedThreadFactory = r -> null;
//                ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, namedThreadFactory);
//                scheduledExecutorService.scheduleAtFixedRate(new Runnable() {
//                    @Override
//                    public void run() {
//
//                    }
//                }, 0, 1, TimeUnit.SECONDS);
//                subNumber(editText, foodInfoBean);
//                return true;
//            });
//            viewHolder.getView(R.id.btn_food_operation_add).setOnLongClickListener(v -> {
//                addNumber(editText, foodInfoBean);
//                return true;
//            });
            editText.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    if (s == null || TextUtil.isEmptyOrNullOrUndefined(s.toString())) {
                        integerMap.put(foodInfoBean.getId(), 0);
                        editText.setText(String.valueOf(0));
                        editText.setSelection(editText.getText().length());
                    } else {
                        integerMap.put(foodInfoBean.getId(), Integer.parseInt(s.toString()));
                    }
                }
            });
        }
    }

    private void addNumber(EditText editText, FoodListInfoBean.DataBean.PurchaseFoodListVOSBean foodInfoBean) {
        Integer number = integerMap.get(foodInfoBean.getId());
        if (number != null) {
            if (number < 9999) {
                number++;
            }
        } else {
            number = 1;
        }
        editText.setText(String.valueOf(number));
        editText.setSelection(editText.getText().length());
        integerMap.put(foodInfoBean.getId(), number);
    }

    private void subNumber(EditText editText, FoodListInfoBean.DataBean.PurchaseFoodListVOSBean foodInfoBean) {
        Integer number = integerMap.get(foodInfoBean.getId());
        if (number != null && number > 0) {
            number--;
            editText.setText(String.valueOf(number));
            editText.setSelection(editText.getText().length());
            integerMap.put(foodInfoBean.getId(), number);
        }
    }
}
