package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerOrderContentComponent;
import com.gingersoft.supply_chain.mvp.contract.OrderContentContract;
import com.gingersoft.supply_chain.mvp.presenter.OrderContentPresenter;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * ================================================
 * Description: 訂單詳情
 * 本次下單所有食品展示頁
 */
public class OrderContentFragment extends BaseSupplyChainFragment<OrderContentPresenter> implements OrderContentContract.View, View.OnClickListener {

    @BindView(R2.id.topbar)
    QMUITopBar topbar;
    @BindView(R2.id.rv_order_content)
    RecyclerView rvOrderContent;
    @BindView(R2.id.cb_order_content_all_select)
    CheckBox cbOrderContentAllSelect;
    @BindView(R2.id.tv_order_content_food_type_total)
    TextView tvOrderContentFoodTypeTotal;
    @BindView(R2.id.tv_order_content_total_amount)
    TextView tvOrderContentTotalAmount;
    @BindView(R2.id.ed_order_content_remark)
    EditText edOrderContentRemark;

    public static OrderContentFragment newInstance() {
        OrderContentFragment fragment = new OrderContentFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerOrderContentComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_order_content, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        cbOrderContentAllSelect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                //全選

            }
        });
    }

    @OnClick({R2.id.btn_order_content_order_template, R2.id.btn_order_content_add_food, R2.id.tv_order_content_complete})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.tv_order_content_complete) {
            //完成

        } else if (viewId == R.id.btn_order_content_order_template) {
            //訂單模板

        } else if (viewId == R.id.btn_order_content_add_food) {
            //添加食材

        }


    }
}
