package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerPurchaseListComponent;
import com.gingersoft.supply_chain.mvp.bean.PurchaseOrderBean;
import com.gingersoft.supply_chain.mvp.contract.PurchaseListContract;
import com.gingersoft.supply_chain.mvp.presenter.PurchaseListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchaseOrderAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchasePageAdapter;
import com.gingersoft.supply_chain.mvp.ui.widget.ScreenView;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.popup.QMUIPopups;
import com.qmuiteam.qmui.widget.tab.QMUIBasicTabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.gingersoft.supply_chain.mvp.ui.fragment.FoodIngredientsFragment.ADD_ORDER;


/**
 * Description:採購列表
 */
public class PurchaseListFragment extends BaseSupplyChainFragment<PurchaseListPresenter> implements PurchaseListContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_purchase_list)
    QMUITopBar mTopBar;
    @BindView(R2.id.purchase_list_tabSegment)
    QMUITabSegment2 mTabSegment;
    @BindView(R2.id.contentViewPager)
    ViewPager2 contentViewPager;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btnNewOrder;
    private PurchaseOrderAdapter purchaseOrderAdapter;
    public static PurchaseListFragment newInstance() {
        PurchaseListFragment fragment = new PurchaseListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerPurchaseListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_purchase_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        btnNewOrder.setText("+新增訂單");
        btnNewOrder.setOnClickListener(v -> {
            //跳轉到下單頁面
            start(FoodIngredientsFragment.newInstance(ADD_ORDER));
        });
        initTopBar();
        initTabAndData();
    }

    private void initTopBar() {
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBar.setTitle("採購列表");
        View view = View.inflate(mContext, R.layout.layout_shopping_cart, null);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mTopBar.addRightView(view, R.id.qmui_shopping_cart, layoutParams);
    }

    private void initTabAndData() {
        QMUITabBuilder builder = mTabSegment.tabBuilder()
                .setNormalColor(ContextCompat.getColor(mContext, R.color.color_86))
                .setSelectColor(ContextCompat.getColor(mContext, R.color.theme_color));

        List<PurchaseOrderBean> orderBeans = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            orderBeans.add(new PurchaseOrderBean("海鮮天地", "123456" + i, System.currentTimeMillis(), 3 * i, "", 10.56 * i));
        }
        purchaseOrderAdapter = new PurchaseOrderAdapter(orderBeans);
        PurchasePageAdapter adapter = new PurchasePageAdapter(purchaseOrderAdapter, 4);
        contentViewPager.setAdapter(adapter);
        mTabSegment.setupWithViewPager(contentViewPager);
        mTabSegment.setIndicator(new QMUITabIndicator(
                QMUIDisplayHelper.dp2px(getContext(), 2), false, false));
        mTabSegment.addTab(builder.setText("全部").build(getContext())).getSelectedIndex();
        mTabSegment.addTab(builder.setText("待收貨").build(getContext()));
        mTabSegment.addTab(builder.setText("部分收貨").build(getContext()));
        mTabSegment.addTab(builder.setText("全部收貨").build(getContext()));
        mTabSegment.notifyDataChanged();
        mTabSegment.setMode(QMUITabSegment.MODE_FIXED);
        mTabSegment.addOnTabSelectedListener(new QMUIBasicTabSegment.OnTabSelectedListener(){
            @Override
            public void onTabSelected(int index) {

            }

            @Override
            public void onTabUnselected(int index) {

            }

            @Override
            public void onTabReselected(int index) {

            }

            @Override
            public void onDoubleTap(int index) {
                mTabSegment.clearSignCountView(index);
            }
        });
    }

    @OnClick({R2.id.layout_purchase_list_screen})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if(viewId == R.id.layout_purchase_list_screen){
            //篩選
            QMUIPopups.popup(mContext, ViewGroup.LayoutParams.MATCH_PARENT)
                    .arrow(false)
                    .shadow(true)
                    .view(new ScreenView(mContext))
                    .offsetYIfTop(QMUIDisplayHelper.dp2px(mContext, 10))
                    .dismissIfOutsideTouch(false)
                    .dimAmount(0.6f)
                    .show(v);
        }
    }
}
