package com.gingersoft.gsa.cloud.table.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.table.di.module.StateTableModule;
import com.gingersoft.gsa.cloud.table.mvp.contract.StateTableContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.StateTableFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2019 17:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = StateTableModule.class, dependencies = AppComponent.class)
public interface StateTableComponent {
    void inject(StateTableFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        StateTableComponent.Builder view(StateTableContract.View view);

        StateTableComponent.Builder appComponent(AppComponent appComponent);

        StateTableComponent build();
    }
}