package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem3;

import java.util.List;

public class OrderCenterDetailFoodAdapter extends BaseQuickAdapter<SectionTextItem3, BaseViewHolder> {

    public OrderCenterDetailFoodAdapter(@Nullable List<SectionTextItem3> data) {
        super(R.layout.item_order_detail_food, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, SectionTextItem3 item) {
        helper.setText(R.id.tv_left, item.getLeftText());
        if (!item.getCenterText().equals("0")) {
            helper.setText(R.id.tv_center, String.valueOf(item.getCenterText()));
            helper.setVisible(R.id.tv_center, true);
        } else {
            helper.setVisible(R.id.tv_center, false);
        }
        if (Double.parseDouble(item.getRightText()) < 0) {
            //折扣
            helper.setText(R.id.tv_right, "-$" + Math.abs(Double.parseDouble(item.getRightText())));
        } else {
            helper.setText(R.id.tv_right, "$" + item.getRightText());
        }
    }

}
