package com.gingersoft.gsa.cloud.common.utils;

import android.util.Log;
import android.view.View;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/2/6
 * Time: 17:21
 * Use:
 */
public class DoubleClickUtils {
    private static long lastClickTime = 0;

    public static boolean isFastDoubleClick() {
        long nowTime = System.currentTimeMillis();
        if (nowTime - lastClickTime < 1000) {//500ms
            LogUtil.w("eee", "間隔小於1000");
//            ToastUtils.show(GsaCloudApplication.getAppContext(), "請慢一點");
            return true;
        }
        lastClickTime = nowTime;
        return false;
    }

    /**
     * 最近一次点击的时间
     */
    private static long mLastClickTime;
    /**
     * 最近一次点击的控件ID
     */
    private static int mLastClickViewId;

    /**
     * 是否是快速点击
     *
     * @param v  点击的控件
     * @param intervalMillis  时间间期（毫秒）
     * @return  true:是，false:不是
     */
    public static boolean isFastDoubleClick(View v, long intervalMillis) {
        int viewId = v.getId();
        long time = System.currentTimeMillis();
        long timeInterval = Math.abs(time - mLastClickTime);
        if (timeInterval < intervalMillis && viewId == mLastClickViewId) {
            return true;
        } else {
            mLastClickTime = time;
            mLastClickViewId = viewId;
            return false;
        }
    }

}
