package com.gingersoft.gsa.cloud.order.bean.discount;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.database.AbstractDiscount;
import com.gingersoft.gsa.cloud.database.DiscountConstact;
import com.gingersoft.gsa.cloud.database.bean.Discount;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2021-04-07 15:45
 * @更新時間: 2021-04-07 15:45
 * @描述: 會員錢包優惠券
 */
@Data
public class MemberWalletCoupon extends AbstractDiscount implements Cloneable {

    /**
     * 记录ID
     */
    private Long discountRecordId;

    private long id;
    private long couponId;
    private String couponTypeName;
    private String beginDate;
    private String endDate;
    private int periodDays;
    private int upperLimitTimes;
    private double billMinAmount;
    private double amount;
    private int discount;
    private String remark;
    private String couponNo;
    private int useTimes;

    public MemberWalletCoupon() {

    }
    public MemberWalletCoupon(MemberWalletCoupon coupon) {
        this.id = coupon.id;
        this.couponId = coupon.couponId;
        this.couponTypeName = coupon.couponTypeName;
        this.beginDate = coupon.beginDate;
        this.endDate = coupon.endDate;
        this.periodDays = coupon.periodDays;
        this.upperLimitTimes = coupon.upperLimitTimes;
        this.billMinAmount = coupon.billMinAmount;
        this.amount = coupon.amount;
        this.discount = coupon.discount;
        this.remark = coupon.remark;
        this.couponNo = coupon.couponNo;
        this.useTimes = coupon.useTimes;
    }

    @NonNull
    @Override
    public MemberWalletCoupon clone() {
        try {
            return (MemberWalletCoupon) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MemberWalletCoupon(this);
    }
}