package com.gingersoft.gsa.cloud.main.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.main.mvp.model.bean.SettlementReportItem;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.SettlementReportActivity;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.SettlementReportItemAdapter;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import javax.inject.Inject;

import com.gingersoft.gsa.cloud.main.mvp.contract.SettlementReportContract;

import java.util.ArrayList;
import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/04/2020 21:36
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class SettlementReportPresenter extends BasePresenter<SettlementReportContract.Model, SettlementReportContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private SettlementReportActivity IActivity;
    private SettlementReportItemAdapter reportItemAdapter;
    private List<SettlementReportItem> mList;

    @Inject
    public SettlementReportPresenter (SettlementReportContract.Model model, SettlementReportContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    public void initAdapter() {
        if (reportItemAdapter == null) {
            mList = new ArrayList<>();
            reportItemAdapter = new SettlementReportItemAdapter(IActivity, mList);
            mRootView.setSettlementReportItemAdapter(reportItemAdapter);
        }
    }

    public void notifyDataSetChanged(List<SettlementReportItem> settlementReportItems) {
        mList.clear();
        mList.addAll(settlementReportItems);
        reportItemAdapter.notifyDataSetChanged();
    }
}
