package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.main.R2;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.main.mvp.contract.SettlementReportContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.SettlementReportPresenter;
import com.qmuiteam.qmui.widget.QMUITopBar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/04/2020 21:36
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class SettlementReportActivity extends BaseActivity<SettlementReportPresenter> implements SettlementReportContract.View {


    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;

    @BindView(R2.id.tv_name)
    TextView tv_name;
    @BindView(R2.id.tv_start_time)
    TextView tv_start_time;
    @BindView(R2.id.tv_end_time)
    TextView tv_end_time;

    @BindView(R2.id.rv_settlement_report_item)
    RecyclerView rv_settlement_report_item;


    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSettlementReportComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_settlement_report; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R2.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                killMyself();
//                overridePendingTransition(R.anim.slide_still, R.anim.slide_out_right);
            }
        });
        mTopBar.setTitle(LanguageUtils.get_language_system(this, "function.order.detail2", "清機報表"));
//        mTopBar.addRightTextButton("打印", R.id.right_img).setOnClickListener(new View.OnClickListener() {
//
//            @Override
//            public void onClick(View v) {
//                if (result != null) {
//
//                    String businessStartTimeRow = LanguageUtils.get_language_system(SettlementReportActivity.this, "from.business.hours", "由營業日期") + " : " + startTime;
//                    String businessEndTimeRow = LanguageUtils.get_language_system(SettlementReportActivity.this, "to.business.hours", "到營業日期") + " : " + endTime;
//
//                    PrintSettlementReport settlementReport = new PrintSettlementReport();
//                    settlementReport.setBrandMachineNameRow(GSAApplication.machineName);
//                    settlementReport.setShopNameRow(LanguageUtils.get_language_system(SettlementReportActivity.this, "shop.number", "店鋪編號") + " : " + GSAApplication.androidSetting.getShopId());
//                    settlementReport.setBusinessStartTimeRow(businessStartTimeRow);
//                    settlementReport.setBusinessEndTimeRow(businessEndTimeRow);
//                    settlementReport.setReportName(LanguageUtils.get_language_system(SettlementReportActivity.this, "EODReport", "清機報表"));
//                    settlementReport.setResult(result);
//                    PrintAction.getInstance().performN5PrintSettlementReport(SettlementReportActivity.this, settlementReport, new PrintAction.onPrintListener() {
//
//                        @Override
//                        public void success() {
//
//                        }
//
//                        @Override
//                        public void failure(String error) {
//
//                        }
//                    });
//                }
//            }
//        });
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }


    @Override
    public void setSettlementReportItemAdapter(DefaultAdapter adapter) {
        setSettlementReportItemRecycleLayoutManager();
        rv_settlement_report_item.setAdapter(adapter);
    }

    public void setSettlementReportItemRecycleLayoutManager() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        rv_settlement_report_item.setLayoutManager(linearLayoutManager);
        rv_settlement_report_item.setItemAnimator(new DefaultItemAnimator());
    }

}
