package com.gingersoft.gsa.cloud.base.common.bean;

import com.gingersoft.gsa.cloud.database.bean.Food;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Wyh on 2020/1/17.
 */
public class OrderBean {
    /**
     * id : 40553
     * orderNo : gs204650350122922
     * status : 0
     * totalAmount : 141.0
     * totalPoints : 0.0
     * createTime : Jan 14, 2020 7:49:50 PM
     * orderDetails : [{"id":1621502,"productName":"胡椒排骨涼瓜煲","productId":"4257","price":58,"lunchboxPrice":0,"number":1,"createTime":"Jan 14, 2020 8:00:11 PM","status":0},{"id":1621503,"productName":"海南雞(例牌)","productId":"4258","price":83,"lunchboxPrice":0,"number":1,"createTime":"Jan 14, 2020 8:00:11 PM","status":0}]
     */

    private int id;
    private String orderNo;
    private int status;
    private double totalAmount;
    private double totalPoints;
    private String createTime;
    private List<OrderDetailsBean> orderDetails;

    public OrderBean() {
    }

    public OrderBean(int id, String orderNo, int status, String createTime) {
        this.id = id;
        this.orderNo = orderNo;
        this.status = status;
        this.createTime = createTime;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getTotalPoints() {
        return totalPoints;
    }

    public void setTotalPoints(double totalPoints) {
        this.totalPoints = totalPoints;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public List<OrderDetailsBean> getOrderDetails() {
        return orderDetails;
    }

    public void setOrderDetails(List<OrderDetailsBean> orderDetails) {
        this.orderDetails = orderDetails;
    }

    public static class OrderDetailsBean {
        /**
         * id : 1621502
         * productName : 胡椒排骨涼瓜煲
         * productId : 4257
         * price : 58.0
         * lunchboxPrice : 0.0
         * number : 1
         * createTime : Jan 14, 2020 8:00:11 PM
         * status : 0
         */
        private int id;
        private String productName;
        private String productId;
        private double price;
        private double lunchboxPrice;
        private int number;
        private String createTime;
        private int status;
        private long orderId;

        public OrderDetailsBean() {
        }

        public OrderDetailsBean(String productName, String productId, double price, double lunchboxPrice, int number, long orderId) {
            this.productName = productName;
            this.productId = productId;
            this.price = price;
            this.lunchboxPrice = lunchboxPrice;
            this.number = number;
            this.orderId = orderId;
        }

        public OrderDetailsBean(String productName, String productId, double price, double lunchboxPrice, int number) {
            this.productName = productName;
            this.productId = productId;
            this.price = price;
            this.lunchboxPrice = lunchboxPrice;
            this.number = number;
        }

        public int getId() {
            return id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getProductName() {
            return productName;
        }

        public void setProductName(String productName) {
            this.productName = productName;
        }

        public String getProductId() {
            return productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public double getPrice() {
            return price;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public double getLunchboxPrice() {
            return lunchboxPrice;
        }

        public void setLunchboxPrice(double lunchboxPrice) {
            this.lunchboxPrice = lunchboxPrice;
        }

        public int getNumber() {
            return number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public String getCreateTime() {
            return createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public int getStatus() {
            return status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public long getOrderId() {
            return orderId;
        }

        public void setOrderId(long orderId) {
            this.orderId = orderId;
        }
    }


//    public static List<OrderDetailsBean> transOrderDetails(List<Food> foods) {
//        List<OrderDetailsBean> orderDetailsBeans = new ArrayList<>();
//        for (Food food : foods) {
//            OrderDetailsBean orderDetailsBean = new OrderDetailsBean(food.getFoodName(), food.getParentId()+ "", food.getPrice(), food.getLunchboxPrice(), food.getNumber(), food.getOrderId());
//            orderDetailsBeans.add(orderDetailsBean);
//        }
//        return orderDetailsBeans;
//    }

    public static List<OrderDetailsBean> transOrderDetails(List<OrderDetail> foods) {
        List<OrderDetailsBean> orderDetailsBeans = new ArrayList<>();
        for (OrderDetail food : foods) {
//            OrderDetailsBean orderDetailsBean = new OrderDetailsBean(food.getName(), food.getParentId()+ "", food.getAmount_price(), food.getLunchboxPrice(), food.getNumber(), food.getOrderId());
            OrderDetailsBean orderDetailsBean = new OrderDetailsBean(food.getName(), food.getParentId()+ "", food.getAmount_price(), food.getLunchboxPrice(), food.getNumber());
            orderDetailsBeans.add(orderDetailsBean);
        }
        return orderDetailsBeans;
    }

}
