package com.gingersoft.gsa.cloud.database.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.NotNull;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.ToMany;

import java.util.List;
import org.greenrobot.greendao.DaoException;
import com.gingersoft.gsa.cloud.database.greendao.DaoSession;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.ModifierDao;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：
 */
@Entity
public class FoodModifier {

    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long dbid;

    @NotNull
    private Long id;
    private Long fid;
    private Long mid;

    //關聯食品表
    @ToMany(referencedJoinProperty = "mid")
    private List<Modifier> modifiers;

    /** Used to resolve relations */
    @Generated(hash = 2040040024)
    private transient DaoSession daoSession;

    /** Used for active entity operations. */
    @Generated(hash = 1456075793)
    private transient FoodModifierDao myDao;


    @Generated(hash = 969556490)
    public FoodModifier(Long dbid, @NotNull Long id, Long fid, Long mid) {
        this.dbid = dbid;
        this.id = id;
        this.fid = fid;
        this.mid = mid;
    }

    @Generated(hash = 1385518392)
    public FoodModifier() {
    }


    public Long getDbid() {
        return dbid;
    }

    public void setDbid(Long dbid) {
        this.dbid = dbid;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFid() {
        return fid;
    }

    public void setFid(Long fid) {
        this.fid = fid;
    }

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#delete(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 128553479)
    public void delete() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.delete(this);
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#refresh(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 1942392019)
    public void refresh() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.refresh(this);
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#update(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 713229351)
    public void update() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.update(this);
    }

    /** called by internal mechanisms, do not call yourself. */
    @Generated(hash = 638717814)
    public void __setDaoSession(DaoSession daoSession) {
        this.daoSession = daoSession;
        myDao = daoSession != null ? daoSession.getFoodModifierDao() : null;
    }

    /**
     * To-many relationship, resolved on first access (and after reset).
     * Changes to to-many relations are not persisted, make changes to the target entity.
     */
    @Generated(hash = 1902490580)
    public List<Modifier> getModifiers() {
        if (modifiers == null) {
            final DaoSession daoSession = this.daoSession;
            if (daoSession == null) {
                throw new DaoException("Entity is detached from DAO context");
            }
            ModifierDao targetDao = daoSession.getModifierDao();
            List<Modifier> modifiersNew = targetDao._queryFoodModifier_Modifiers(dbid);
            synchronized (this) {
                if (modifiers == null) {
                    modifiers = modifiersNew;
                }
            }
        }
        return modifiers;
    }

    /** Resets a to-many relationship, making the next get call to query for a fresh result. */
    @Generated(hash = 51124353)
    public synchronized void resetModifiers() {
        modifiers = null;
    }
}
