package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.di.component.DaggerNewSupplierComponent;
import com.gingersoft.supply_chain.mvp.contract.NewSupplierContract;
import com.gingersoft.supply_chain.mvp.presenter.NewSupplierPresenter;
import com.jess.arms.di.component.AppComponent;


/**
 * ================================================
 * Description:新增或編輯供應商
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 18:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class NewSupplierFragment extends BaseSupplyChainFragment<NewSupplierPresenter> implements NewSupplierContract.View {

    public static NewSupplierFragment newInstance() {
        NewSupplierFragment fragment = new NewSupplierFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerNewSupplierComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_new_supplier, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }

}
