package com.gingersoft.gsa.cloud.account.user;

import com.gingersoft.gsa.cloud.account.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.account.user.info.UserInfo;
import com.gingersoft.gsa.cloud.account.user.state.LoginedState;
import com.gingersoft.gsa.cloud.account.user.state.LogoutState;
import com.gingersoft.gsa.cloud.account.user.state.UserState;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;

import lombok.Getter;
import lombok.Setter;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:用戶接口和狀態管理類
 */
@Getter
@Setter
public class UserContext {

    private static UserContext sUserContextManger = null;

    /**
     * 用戶狀態
     */
    private UserState state = new LogoutState();

    /**
     * 用戶信息
     */
    private UserInfo info;


    private UserContext() {
    }

    public static UserContext newInstance() {
        if (sUserContextManger == null) {
            synchronized (UserContext.class) {
                if (sUserContextManger == null) {
                    sUserContextManger = new UserContext();
                }
            }
        }
        return sUserContextManger;
    }

    public  void logined(){
        state.logined();
    }

    public void logOut(){
        state.logOut();
    }

    public void toTargetPage(String componentName,String actionName){
        state.toTargetPage(componentName,actionName);
    }

    /**
     * 用戶是否登錄
     * @return
     */
    public boolean isLogin(){
        if(state instanceof LoginedState){
            return true;
        }
        return false;
    }


    public void putUserInfo(UserInfo info) {
        SPUtils.put(UserConstans.token, info.getUserName());
        SPUtils.put(UserConstans.memberId, info.getUserName());
        SPUtils.put(UserConstans.memberName, info.getUserName());
    }

    public void removeUserInfo(){
        SPUtils.remove(UserConstans.token);
        SPUtils.remove(UserConstans.memberId);
        SPUtils.remove(UserConstans.memberName);
        //刪除用戶信息的同時 將品牌，餐廳信息一起刪除
        ResturantInfoManager.newInstance().removeBrandInfo();
        ResturantInfoManager.newInstance().removeResturantInfo();
    }

    public static String getLoginToken() {
        return (String) SPUtils.get(UserConstans.token, "");
    }

    public static int getMemberId() {
        return (int) SPUtils.get(UserConstans.memberId, 0);
    }

    public static String getMemberName() {
        return (String) SPUtils.get(UserConstans.memberName, "");
    }
}
