package com.gingersoft.gsa.cloud.account.user.state;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.account.user.UserContext;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.constans.PrintConstans;
import com.gingersoft.gsa.cloud.account.user.UserConstans;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:已登錄狀態
 */
public class LoginedState implements UserState{


    @Override
    public void logined() {
        //跳轉登錄頁面
        CC.obtainBuilder("User.Component.Login")
                .setActionName("showActivityA")
                .build()
                .call();
    }

    @Override
    public void logOut() {
        //設置用戶狀態為登出狀態
        UserContext.newInstance().setState(new LogoutState());
        UserContext.newInstance().logOut();
    }

    @Override
    public void toTargetPage(String componentName, String actionName) {
        CC.obtainBuilder(componentName)
                .setActionName(actionName)
                .build()
                .call();
    }

}
