package com.gingersoft.gsa.cloud.account.user.state;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.account.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.account.user.UserConstans;
import com.gingersoft.gsa.cloud.account.user.UserContext;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.constans.PrintConstans;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:未登錄狀態
 */
public class LogoutState implements UserState{


    @Override
    public void logined() {
        //設置用戶狀態為登錄狀態
        UserContext.newInstance().setState(new LoginedState());
        UserContext.newInstance().logined();
    }

    @Override
    public void logOut() {

        SPUtils.put(UserConstans.IS_LOGIN, false);

        UserContext.newInstance().removeUserInfo();

        //关闭Prj打印服務
        CC.obtainBuilder("Component.Print")
                .setActionName("stopPrintService")
                .build()
                .call();
        //跳轉登陸頁面
        CC.obtainBuilder("User.Component.Login")
                .setActionName("showActivityA")
                .build()
                .call();
    }

    @Override
    public void toTargetPage(String componentName, String actionName) {
        CC.obtainBuilder(componentName)
                .setActionName(actionName)
                .build()
                .call();
    }

}
