package com.gingersoft.gsa.cloud.database.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;

import java.io.Serializable;

import lombok.Data;

/**
 * Created by Wyh on 2020/1/17.
 */
@Entity
@Data
public class PrinterDeviceBean implements Serializable {
    public static final int PRINT_IP = 1;
    public static final int PRINT_LOCAL = 2;
    public static final int PRINT_USB = 3;
    public static final int PRINT_PRJ_PC = 4;

    private static final long serialVersionUID = 4583366043598445115L;

    private Long id;

    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long dbid;
    private String name;
    private Integer restaurantId;
    private String ip;//ip
    private Long uid;
    private Integer port;//端口
    private Integer type;//2為默認打印機，1為普通打印機

    private Long printerModelId;//打印機機型id
    private String paperSpecification;//紙張規格
    private int lineFontStop;//打印機一行最多顯示多少字
    private String printerName;//打印機機型名稱
    private String model;//打印機型號


    private String noteContent;//備註
    private Long printerDeviceDefaultId;

    private int printerDeviceType;//打印機類型 1：網絡打印  2：本地打印(N5,Sunmi手持打印) 3：USB打印 4：藍牙打印
    /**
     * PRJ模式時填寫的打印路徑，PC端共享文件夾的路徑
     */
    private String printPath;
    /**
     * 飛單1打印機id
     */
    private Long flyPrinterDeviceId;
    /**
     * 飛單2 打印機id
     */
    private Long flyPrinterDeviceId2;

    private int foodComplexion;//食品顔色 0 黑色 2 紅色

    private int modifierComplexion;//細項顔色  0 黑色 2 紅色

    private int foodIsBold;//食品是否加粗 0預設 1是 2否

    private String foodFont;//食品字體大小 0預設

    private int foodIsItalic;//食品是否斜體 0預設 1是 2否

    private int modifierIsBold;//細項是否加粗 0預設 1是 2否

    private String modifierFont;//細項字號 0預設

    private int modifierIsItalic;//細項是否斜體 0預設 1是 2否

    private int numberIsFlip;//數量大於1顔色是否翻轉 0預設 1是 2否

    private String languageType;

    @Generated(hash = 626885316)
    public PrinterDeviceBean() {
    }

    public PrinterDeviceBean(String ip, Integer port, String paperSpecification) {
        this.ip = ip;
        this.port = port;
        this.paperSpecification = paperSpecification;
    }

    @Generated(hash = 1843654148)
    public PrinterDeviceBean(Long id, Long dbid, String name, Integer restaurantId, String ip, Long uid, Integer port, Integer type, Long printerModelId, String paperSpecification, int lineFontStop, String printerName, String model, String noteContent, Long printerDeviceDefaultId, int printerDeviceType, String printPath, Long flyPrinterDeviceId, Long flyPrinterDeviceId2, int foodComplexion, int modifierComplexion, int foodIsBold, String foodFont, int foodIsItalic, int modifierIsBold,
            String modifierFont, int modifierIsItalic, int numberIsFlip, String languageType) {
        this.id = id;
        this.dbid = dbid;
        this.name = name;
        this.restaurantId = restaurantId;
        this.ip = ip;
        this.uid = uid;
        this.port = port;
        this.type = type;
        this.printerModelId = printerModelId;
        this.paperSpecification = paperSpecification;
        this.lineFontStop = lineFontStop;
        this.printerName = printerName;
        this.model = model;
        this.noteContent = noteContent;
        this.printerDeviceDefaultId = printerDeviceDefaultId;
        this.printerDeviceType = printerDeviceType;
        this.printPath = printPath;
        this.flyPrinterDeviceId = flyPrinterDeviceId;
        this.flyPrinterDeviceId2 = flyPrinterDeviceId2;
        this.foodComplexion = foodComplexion;
        this.modifierComplexion = modifierComplexion;
        this.foodIsBold = foodIsBold;
        this.foodFont = foodFont;
        this.foodIsItalic = foodIsItalic;
        this.modifierIsBold = modifierIsBold;
        this.modifierFont = modifierFont;
        this.modifierIsItalic = modifierIsItalic;
        this.numberIsFlip = numberIsFlip;
        this.languageType = languageType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDbid() {
        return dbid;
    }

    public void setDbid(Long dbid) {
        this.dbid = dbid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(Integer restaurantId) {
        this.restaurantId = restaurantId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getType() {
        if (type == null) {
            return 0;
        }
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getPrinterModelId() {
        return printerModelId;
    }

    public void setPrinterModelId(Long printerModelId) {
        this.printerModelId = printerModelId;
    }

    public String getPaperSpecification() {
        return paperSpecification;
    }

    public void setPaperSpecification(String paperSpecification) {
        this.paperSpecification = paperSpecification;
    }

    public String getPrinterName() {
        return printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getNoteContent() {
        return noteContent;
    }

    public void setNoteContent(String noteContent) {
        this.noteContent = noteContent;
    }

    public Long getFlyPrinterDeviceId() {
        return flyPrinterDeviceId;
    }

    public void setFlyPrinterDeviceId(Long flyPrinterDeviceId) {
        this.flyPrinterDeviceId = flyPrinterDeviceId;
    }

    public Long getFlyPrinterDeviceId2() {
        return flyPrinterDeviceId2;
    }

    public void setFlyPrinterDeviceId2(Long flyPrinterDeviceId2) {
        this.flyPrinterDeviceId2 = flyPrinterDeviceId2;
    }

    public Long getPrinterDeviceDefaultId() {
        return printerDeviceDefaultId;
    }

    public void setPrinterDeviceDefaultId(Long printerDeviceDefaultId) {
        this.printerDeviceDefaultId = printerDeviceDefaultId;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public int getFoodIsBold() {
        return foodIsBold;
    }

    public void setFoodIsBold(int foodIsBold) {
        this.foodIsBold = foodIsBold;
    }

    public String getFoodFont() {
        return foodFont;
    }

    public void setFoodFont(String foodFont) {
        this.foodFont = foodFont;
    }

    public int getFoodIsItalic() {
        return foodIsItalic;
    }

    public void setFoodIsItalic(int foodIsItalic) {
        this.foodIsItalic = foodIsItalic;
    }

    public int getModifierIsBold() {
        return modifierIsBold;
    }

    public void setModifierIsBold(int modifierIsBold) {
        this.modifierIsBold = modifierIsBold;
    }

    public String getModifierFont() {
        return modifierFont;
    }

    public void setModifierFont(String modifierFont) {
        this.modifierFont = modifierFont;
    }

    public int getModifierIsItalic() {
        return modifierIsItalic;
    }

    public void setModifierIsItalic(int modifierIsItalic) {
        this.modifierIsItalic = modifierIsItalic;
    }

    public int getNumberIsFlip() {
        return numberIsFlip;
    }

    public void setNumberIsFlip(int numberIsFlip) {
        this.numberIsFlip = numberIsFlip;
    }

    public int getLineFontStop() {
        return lineFontStop;
    }

    public void setLineFontStop(int lineFontStop) {
        this.lineFontStop = lineFontStop;
    }

    public int getPrinterDeviceType() {
        return printerDeviceType;
    }

    public void setPrinterDeviceType(int printerDeviceType) {
        this.printerDeviceType = printerDeviceType;
    }

    public int getFoodComplexion() {
        return foodComplexion;
    }

    public void setFoodComplexion(int foodComplexion) {
        this.foodComplexion = foodComplexion;
    }

    public int getModifierComplexion() {
        return modifierComplexion;
    }

    public void setModifierComplexion(int modifierComplexion) {
        this.modifierComplexion = modifierComplexion;
    }

    public String getLanguageType() {
        return languageType;
    }

    public void setLanguageType(String languageType) {
        this.languageType = languageType;
    }

    public String getPrintPath() {
        return this.printPath;
    }

    public void setPrintPath(String printPath) {
        this.printPath = printPath;
    }
}
