package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.di.component.DaggerSupplierListComponent;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;
import com.gingersoft.supply_chain.mvp.contract.SupplierListContract;
import com.gingersoft.supply_chain.mvp.presenter.SupplierListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.SupplierAdapter;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 17:41
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class SupplierListFragment extends BaseSupplyChainFragment<SupplierListPresenter> implements SupplierListContract.View, View.OnClickListener {

    @BindView(R.id.topbar_supplier_list)
    QMUITopBar mTopBarSupplierList;
    @BindView(R.id.rv_supplier_list)
    RecyclerView rvSupplierList;
    @BindView(R.id.btn_new_supplier)
    QMUIAlphaButton btnNewSupplier;

    public final static int SUPPLIER_LIST = 101;

    public static SupplierListFragment newInstance() {
        SupplierListFragment fragment = new SupplierListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerSupplierListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_supplier_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar();

        List<SupplierInfoBean> supplierInfoBeans = new ArrayList<>();
        supplierInfoBeans.add(new SupplierInfoBean("海鮮天地", "香港長沙灣青山道479A麗昌大廈", "23719831", "李先生", "2020-11-19"));
        supplierInfoBeans.add(new SupplierInfoBean("海鮮天地", "香港長沙灣青山道479A麗昌大廈", "23719831", "李先生", "2020-11-19"));
        supplierInfoBeans.add(new SupplierInfoBean("海鮮天地", "香港長沙灣青山道479A麗昌大廈", "23719831", "李先生", "2020-11-19"));
        SupplierAdapter supplierAdapter = new SupplierAdapter(supplierInfoBeans);
        rvSupplierList.setAdapter(supplierAdapter);

        supplierAdapter.setOnItemClickListener((adapter, view, position) -> startForResult(NewSupplierFragment.newInstance(), SUPPLIER_LIST));
        supplierAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            if (view.getId() == R.id.iv_supplier_delete) {
                new AppDialog().showWaringDialog(mContext, "刪除供應商", (view1, dialog) -> {
                    dialog.dismiss();
                    supplierAdapter.removeAt(position);
                });
            }
        });
    }

    private void initTopBar() {
        mTopBarSupplierList.setTitle("供應商");
        mTopBarSupplierList.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBarSupplierList.addRightImageButton(R.drawable.ic_screen, R.id.topbar_right_screen_button).setOnClickListener(this);
    }

    @OnClick({R.id.btn_new_supplier})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_right_screen_button) {
            //篩選
        } else if (viewId == R.id.btn_new_supplier) {
            //新增供應商
            startForResult(NewSupplierFragment.newInstance(), SUPPLIER_LIST);
        }
    }

    @Override
    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (requestCode == SUPPLIER_LIST) {
            //新增或編輯了供應商，重新獲取所有供應商數據

        }
    }
}
