package com.gingersoft.gsa.cloud.user.login.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.user.login.mvp.bean.TestLoginBean;
import com.gingersoft.gsa.cloud.user.login.mvp.server.LoginService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;
import javax.inject.Inject;

import com.gingersoft.gsa.cloud.user.login.mvp.contract.LoginContract;
import com.joe.base.utils.encryption.DESUtil;
import com.joe.base.utils.request.RequestUtils;

import java.util.HashMap;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/21/2019 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class LoginModel extends BaseModel implements LoginContract.Model{
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public LoginModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public Observable<TestLoginBean> login(HashMap<String, Object> params) {
//        RetrofitUrlManager.getInstance().putDomain("common", "http://gingersoft.tpddns.cn:58201/");
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .login(DESUtil.encrypt(mGson.toJson(params)));
    }


    @Override
    public Observable<TestLoginBean> loginOut(HashMap<String, Object> params) {
//        RetrofitUrlManager.getInstance().putDomain("common", "http://gingersoft.tpddns.cn:58201/");
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .loginOut(DESUtil.encrypt(mGson.toJson(params)));
    }
}