package com.gingersoft.gsa.cloud.user.login.mvp.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import com.alibaba.fastjson.JSON;
import com.gingersoft.gsa.cloud.user.login.R;
import com.gingersoft.gsa.cloud.user.login.mvp.bean.TestLoginBean;
import com.joe.base.utils.encryption.Aes;
import com.joe.base.utils.toast.ToastUtils;

import java.io.IOException;

import androidx.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * Created by Wyh on 2019/12/25.
 */
public class LoginOutActivity extends Activity {
    private TestLoginBean loginBean;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.user_login_activity_login_out);
        TextView tv_json = findViewById(R.id.tv_json);

        String json = getIntent().getStringExtra("json");
        loginBean = JSON.parseObject(json, TestLoginBean.class);
        tv_json.setText(json);

        findViewById(R.id.tv_gsa_user_loginout).setOnClickListener(v -> {
            OkHttpClient okHttpClient = new OkHttpClient();
            RequestBody requestBody = new FormBody.Builder()
                    .build();
            Log.e("aaa", "加密前：" + loginBean.getData().getUser().getId() + "_" + System.currentTimeMillis() + "_" + loginBean.getData().getToken());
            // 加密token  apptype_id_time_token
            // app類型_用戶id_時間戳_登陸token
            String head = Aes.aesEncrypt("9_" + loginBean.getData().getUser().getId() + "_" + System.currentTimeMillis() + "_" + loginBean.getData().getToken()).replaceAll("\r|\n", "");
            Log.e("aaa", "加密頭部：" + head);
            Request request = new Request.Builder()
                    .addHeader("mobileId", "1")
                    .addHeader("mobielModel", "")
                    .addHeader("mobileVersion", "")
                    .addHeader("token", head)
                    .url("http://gingersoft.tpddns.cn:58201/ricepon-cloud-gsa/api/gsa/logout")
                    .post(requestBody)
                    .build();
            okHttpClient.newCall(request).enqueue(new Callback() {
                @Override
                public void onFailure(Call call, IOException e) {
                    Log.e("aaa", "onFailure: " + e.getMessage());
                }

                @Override
                public void onResponse(Call call, Response response) throws IOException {
                    String json = response.body().string();
                    Log.e("aaa", "退出登錄：" + json);
                    ToastUtils.show(LoginOutActivity.this, "登出");
                    Intent intent = new Intent(LoginOutActivity.this, LoginActivity.class);
                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                    startActivity(intent);
                }
            });

        });


    }
}
