package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.FoodBean;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ComboItemDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.SoldoutCtrlContract;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MealService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/22/2020 10:39
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class SoldoutCtrlModel extends BaseModel implements SoldoutCtrlContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public SoldoutCtrlModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public List<Food> queryDB_FoodListByIds(String[] ids) {
        String sql = "SELECT * FROM FOOD WHERE id IN ( ?, ? );";
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodByNativeSql(sql,ids);
        return foods;
    }

    @Override
    public List<Food> queryDB_AllFoodList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryAllFoodByQueryBuilder();
        return foods;
    }

    @Override
    public List<Food> queryDB_FoodGroupList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodGroupByQueryBuilder();
        return foods;
    }

    @Override
    public List<Food> queryDB_FoodList(long parentId) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodByQueryBuilder(parentId);
        return foods;
    }

    @Override
    public Observable<BaseResult> getCurrentSoldoutFood(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .getCurrentSoldoutFood(requestBody);
    }

    @Override
    public Observable<BaseResult> insertSoldoutCtrl(RequestBody requestBody, int operatTtpe, int type) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .insertSoldoutCtrl(requestBody);
//                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
//                    @Override
//                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
//                        if (info != null && info.isSuccess()) {
//                            if (operatTtpe == 0) {
//                                int restaurantId = GsaCloudApplication.getRestaurantId(mApplication);
//                                switch (type) {
//                                    case 1:
//                                    case 2:
//                                        //更新食品狀態
//                                        return downFoodList(restaurantId);
//                                    case 3:
//                                        //更新細項狀態
//                                        return downFoodModifier(restaurantId);
//                                }
//                            }
//                        }
//                        return null;
//                    }
//                });
    }

    @Override
    public Observable<BaseResult> restoreSoldoutCtrl(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .restoreSoldoutCtrl(requestBody);
    }

    @Override
    public Observable<BaseResult> batchRestoreSoldoutCtrl(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .batchRestoreSoldoutCtrl(requestBody);
    }

    @Override
    public Observable<BaseResult> updateInvisible(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .updateInvisible(requestBody);
    }

    @Override
    public Observable<FoodBean> downFoodList(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .downFoodList(restaurantId);
    }

    @Override
    public Observable<BaseResult> downFoodModifier(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(MealService.class)
                .downFoodModifier(restaurantId);
    }

}