package com.gingersoft.gsa.other_order_mode.ui.adapter

import android.animation.AnimatorSet
import android.animation.ObjectAnimator.ofFloat
import android.animation.ValueAnimator
import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.core.content.ContextCompat
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.Adapter
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.OrderList
import com.gingersoft.gsa.other_order_mode.databinding.LayoutOtherOrderItemBinding
import com.scwang.smartrefresh.layout.util.SmartUtil.dp2px

class OtherOrdersAdapter(var context: Context) : Adapter<OtherOrdersAdapter.ViewHolder>() {

    private var databeans: List<OrderList.DataBeanX.DataBean>? = null

    private var listenter: ((item: OrderList.DataBeanX.DataBean) -> Unit)? = null

    fun setOnItemClickListenter(listenter: (item: OrderList.DataBeanX.DataBean) -> Unit) {
        this.listenter = listenter
    }

    fun setData(databeans: List<OrderList.DataBeanX.DataBean>) {
        this.databeans = databeans
        notifyDataSetChanged()
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.layout_other_order_item, parent, false))
    }


    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = this.databeans!![position]
        holder.binding.data = data
        holder.binding.isSelf = data.order_type == 7

        holder.binding.deliveryState = when (data.curStat) {
            1 -> "已通知物流"
            2 -> "配送員已接單"
            3 -> "配送員到店附近"
            4 -> "配送員已到店"
            5 -> "配送中"
            6 -> "到達目的地附近"
            7 -> "訂單已完成"
            8 -> "物流已取消"//取餐前
            9 -> "物流已取消"//取餐後
            10 -> "已指派另一位配送員"
            else -> ""
        }

        var state: String? = null
        val bg = GradientDrawable()
        bg.cornerRadius = dp2px(5f).toFloat()
        holder.flBorder.visibility = View.GONE//隱藏邊框
        when {
            data.STATUS == 0 -> {
                state = "待確認"
                bg.setColor(getColor(R.color.order_state0_color))

                //執行動畫
                if (data.isRead == 0) {
                    holder.flBorder.visibility = View.VISIBLE//顯示邊框
                    alphaAnimator(holder.flBorder)
                } else {
                    holder.flBorder.visibility = View.GONE
                    holder.flBorder.clearAnimation()
                }
            }
            data.STATUS == 1 -> {
                state = "待確認"
                bg.setColor(getColor(R.color.order_state0_color))
                holder.flBorder.visibility = View.VISIBLE//顯示邊框
                //執行動畫
                if (data.isRead == 0) {
                    holder.flBorder.visibility = View.VISIBLE//顯示邊框
                    alphaAnimator(holder.flBorder)
                } else {
                    holder.flBorder.visibility = View.GONE
                    holder.flBorder.clearAnimation()
                }
            }
            data.STATUS == 2 -> {
                state = "製作中"
                bg.setColor(getColor(R.color.order_state1_color))
            }
            data.STATUS == 3 -> {
                state = if (data.order_type == 7) {
                    "待取餐"
                } else {
                    "派送中"
                }
                bg.setColor(getColor(R.color.order_state2_color))
            }
        }
        holder.binding.state = state
        holder.binding.stateBg = bg

        //堂食外賣背景
        val orderingMethodBg = GradientDrawable()
        orderingMethodBg.shape = GradientDrawable.RECTANGLE
        orderingMethodBg.cornerRadii = floatArrayOf(dp2px(8f).toFloat(), dp2px(8f).toFloat(), 0f, 0f, 0f, 0f, dp2px(8f).toFloat(), dp2px(8f).toFloat())

        holder.binding.orderingMethod =
                when {
                    data.order_type == 2 -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state2_color))
                        "外送"
                    }
                    data.order_type == 7 -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state3_color))
                        "自取"
                    }
                    else -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state1_color))
                        "堂食"
                    }
                }
        holder.binding.orderingMethodBg = orderingMethodBg

        //支付方式背景 data.orderPayType==1?@color/table_send:@color/table_use
        //data.orderPayType==1?@string/cash_on_delivery:@string/online_payments
        val payMethodBg = GradientDrawable()
        payMethodBg.cornerRadius = dp2px(10f).toFloat()
        holder.binding.payMethod =
                when {
                    data.orderPayType == 1 -> {
                        payMethodBg.setColor(getColor(R.color.cash_on_delivery_bg))
                        "貨到付款"
                    }
                    else -> {
                        payMethodBg.setColor(getColor(R.color.online_payments_bg))
                        "在線支付"
                    }
                }
        holder.binding.payMethodBg = payMethodBg

        holder.itemView.setOnClickListener {
            listenter?.invoke(data)
        }

    }

    private fun alphaAnimator(view: View) {
        val animatorSet = AnimatorSet()
        val ofFloat = ofFloat(view, "alpha", 0f, 1f)
        ofFloat.duration = 200
        ofFloat.repeatCount = -1
        ofFloat.repeatMode = ValueAnimator.REVERSE

        val ofFloat1 = ofFloat(view, "alpha", 1f, 0f)
        ofFloat1.duration = 200
        ofFloat1.repeatCount = -1
        ofFloat1.repeatMode = ValueAnimator.REVERSE

        animatorSet.play(ofFloat).with(ofFloat1)
        animatorSet.duration = 400
        animatorSet.start()
    }


    override fun getItemCount(): Int {
        return if (databeans == null) {
            0
        } else {
            databeans!!.size
        }
    }

    private fun getColor(color: Int): Int {
        return ContextCompat.getColor(context, color)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var binding: LayoutOtherOrderItemBinding = DataBindingUtil.bind(itemView)!!
        var flBorder: FrameLayout = itemView.findViewById(R.id.fl_border)
    }
}