package com.gingersoft.gsa.cloud.main.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.utils.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.main.mvp.contract.MainTopContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.HomeTurnoverBean;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/18/2020 17:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class MainTopPresenter extends BasePresenter<MainTopContract.Model, MainTopContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public MainTopPresenter(MainTopContract.Model model, MainTopContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getRestaurantReport(String restaurantId) {
        RequestBody requestBody = new FormBody.Builder()
                .add("restaurantId", restaurantId)
                .add("startTime", TimeUtils.getYesterdayTime(TimeUtils.DATE_FORMAT_DATE))
                .add("endTime", TimeUtils.getCurrentTimeInString(TimeUtils.DATE_FORMAT_DATE))
                .build();

        mModel.getRestaurantReport(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<HomeTurnoverBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull HomeTurnoverBean info) {
                        if (info != null && info.isSuccess()) {
                            if (info.getData() != null) {
                                mRootView.loadBusinessInfo(info.getData());
                            }
                        } else {
                            mRootView.showMessage("營業報表獲取失敗");
                        }
                    }

                    @Override
                    public void onComplete() {
                        super.onComplete();
                        RetrofitUrlManager.getInstance().putDomain("common", HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL);
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        RetrofitUrlManager.getInstance().putDomain("common", HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL);
                    }
                });
    }

    //http://a.ricepon.com:61177/member-web/api/wx/findOrderInfoChart  獲取消費曲線圖
    //{"success":true,"sysTime":1582375800036,"data":[{"date":"2020-02-22","items":[{"person":"0","amount":0.0,"hours":"12","count":1,"date":"2020-02-22"},{"person":"0","amount":42.2,"hours":"14","count":3,"date":"2020-02-22"},{"person":"0","amount":21.1,"hours":"15","count":3,"date":"2020-02-22"},{"person":"0","amount":136.0,"hours":"17","count":3,"date":"2020-02-22"},{"person":"0","amount":58.0,"hours":"18","count":1,"date":"2020-02-22"}]}]}
}
