package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/2/24.
 * 排序編號adapter
 */
public class SortNumberingAdapter extends BaseQuickAdapter<String, BaseViewHolder> {
   private Context mContext;

    public SortNumberingAdapter(Context mContext, @Nullable List<String> data) {
        super(R.layout.item_ranking_numbering, data);
        this.mContext = mContext;
    }

    @Override
    protected void convert(BaseViewHolder helper, String item) {
        helper.getView(R.id.iv_ranking_numbering).setVisibility(View.GONE);
        if (helper.getAdapterPosition() == 0) {
            helper.setText(R.id.tv_ranking_numbering, "排序");
            helper.setTextColor(R.id.tv_ranking_numbering, mContext.getResources().getColor(R.color.theme_hint_color));
        } else if (helper.getAdapterPosition() == 1) {
            helper.setText(R.id.tv_ranking_numbering, "");
            helper.setImageResource(R.id.iv_ranking_numbering, R.drawable.ic_ranking_first);
            helper.getView(R.id.iv_ranking_numbering).setVisibility(View.VISIBLE);
        } else if (helper.getAdapterPosition() == 2) {
            helper.setText(R.id.tv_ranking_numbering, "");
            helper.setImageResource(R.id.iv_ranking_numbering, R.drawable.ic_ranking_second);
            helper.getView(R.id.iv_ranking_numbering).setVisibility(View.VISIBLE);
        } else if (helper.getAdapterPosition() == 3) {
            helper.setText(R.id.tv_ranking_numbering, "");
            helper.setImageResource(R.id.iv_ranking_numbering, R.drawable.ic_ranking_third);
            helper.getView(R.id.iv_ranking_numbering).setVisibility(View.VISIBLE);
        } else {
            helper.setText(R.id.tv_ranking_numbering, helper.getAdapterPosition() + "");
            helper.setTextColor(R.id.tv_ranking_numbering, mContext.getResources().getColor(R.color.color_8f));
        }
    }
}
