package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.Combo;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.greendao.ComboDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class ComboDaoUtils {

    private static final String TAG = ComboDaoUtils.class.getSimpleName();
    private DaoManager mManager;
    private Context mContext;

    public ComboDaoUtils(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
        this.mContext = context;
    }

    /**
     * 完成Food记录的插入，如果表未创建，先创建Food表
     *
     * @param combo
     * @return
     */
    public boolean insertCombo(Combo combo) {
        boolean flag = false;
        flag = mManager.getDaoSession().getComboDao().insert(combo) == -1 ? false : true;
        Log.i(TAG, "insert Combo :" + flag + "-->" + combo.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     *
     * @param foodList
     * @return
     */
    public boolean insertMultCombo(final List<Combo> foodList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (Combo Food : foodList) {
                        mManager.getDaoSession().insertOrReplace(Food);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     *
     * @param combo
     * @return
     */
    public boolean updateCombo(Combo combo) {
        boolean flag = false;
        try {
            mManager.getDaoSession().update(combo);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     *
     * @param food
     * @return
     */
    public boolean deleteCombo(Combo food) {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(food);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     *
     * @return
     */
    public boolean deleteAll() {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(Combo.class);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     *
     * @return
     */
    public List<Combo> queryAllCombo() {
        return mManager.getDaoSession().loadAll(Combo.class);
    }

    /**
     * 根据主键id查询记录
     *
     * @param key
     * @return
     */
    public Combo queryComboById(long key) {
        return mManager.getDaoSession().load(Combo.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<Combo> queryComboByNativeSql(String sql, String[] conditions) {
        return mManager.getDaoSession().queryRaw(Combo.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public List<Combo> queryComboFoodsByQueryBuilder(long fid) {
        Combo combo = queryComboByQueryBuilder(fid);
        List<Combo> combos = null;
        if (combo != null) {
            combos = queryCombosByComIdQueryBuilder(combo.getComId());
        }
        List<Combo> list = new ArrayList<>();
        FoodDaoUtils foodDao = new FoodDaoUtils(mContext);
        if (combos != null) {
            for (int i = 0; i < combos.size(); i++) {
                Food food = foodDao.queryFoodByFidQueryBuilder(combos.get(i).getFid());
                if (food != null) {
                    list.add(Combo.addFoodInfo(food, combos.get(i)));
                }
            }
        }
        return list;
    }

    public List<Combo> queryCombosFoodsByQueryBuilder(long fid) {
        List<Combo> combo = queryCombosByQueryBuilder(fid);
        List<Combo> combos = null;
        if (combo != null && combo.size() != 0) {
            combos = queryCombosByComIdQueryBuilder(combo.get(0).getComId());
        }
        List<Combo> list = new ArrayList<>();
        FoodDaoUtils foodDao = new FoodDaoUtils(mContext);
        if (combos != null) {
            for (int i = 0; i < combos.size(); i++) {
                Food food = foodDao.queryFoodByFidQueryBuilder(combos.get(i).getFid());
                if(food != null) {
                    list.add(Combo.addFoodInfo(food, combos.get(i)));
                }
            }
        }
        return list;
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public Combo queryComboByQueryBuilder(long fid) {
        QueryBuilder<Combo> queryBuilder = mManager.getDaoSession().queryBuilder(Combo.class);
        return queryBuilder.where(ComboDao.Properties.Fid.eq(fid)).build().unique();
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public List<Combo> queryCombosByQueryBuilder(long fid) {
        QueryBuilder<Combo> queryBuilder = mManager.getDaoSession().queryBuilder(Combo.class);
        return queryBuilder.where(ComboDao.Properties.Fid.eq(fid)).build().list();
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public List<Combo> queryCombosByComIdQueryBuilder(int comId) {
        QueryBuilder<Combo> queryBuilder = mManager.getDaoSession().queryBuilder(Combo.class);
        return queryBuilder.where(ComboDao.Properties.ComId.eq(comId)).list();
    }
}
